/*
 * Decompiled with CFR 0.152.
 */
package pdp.web;

import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pdp.JsonMapper;
import pdp.domain.PdpDecision;
import pdp.repositories.PdpDecisionRepository;
import pdp.repositories.PdpPolicyRepository;
import pdp.stats.StatsContext;

@RestController
@RequestMapping(headers={"Content-Type=application/json"}, produces={"application/json"})
public class StatsController
implements JsonMapper {
    @Autowired
    private PdpDecisionRepository pdpDecisionRepository;
    @Autowired
    private PdpPolicyRepository pdpPolicyRepository;

    @GetMapping(value={"/internal/decisions"})
    public List<PdpDecision> decisions(@RequestParam(value="daysAgo") int daysAgo) {
        Date date = Date.from(Instant.now().minus(daysAgo, ChronoUnit.DAYS));
        return this.pdpDecisionRepository.findByCreatedAfter(date);
    }

    @GetMapping(value={"internal/loas-stats"})
    public Map<String, Map<String, Integer>> loas() {
        HashMap<String, Map<String, Integer>> result = new HashMap<String, Map<String, Integer>>();
        int page = 0;
        int pageSize = 1000;
        PageRequest pageable = new PageRequest(page, pageSize, Sort.Direction.ASC, new String[]{"id"});
        Page decisionPage = this.pdpDecisionRepository.findAll((Pageable)pageable);
        do {
            decisionPage.getContent().forEach(decision -> {
                StatsContext statsContext = this.statsContext(decision);
                String loa = statsContext.getLoa();
                String policyId = statsContext.getPolicyId();
                Optional policyOptional = this.pdpPolicyRepository.findFirstByPolicyIdAndLatestRevision(policyId, true);
                String policyName = policyOptional.map(policy -> policy.getName()).orElse(policyId);
                if (loa != null && policyName != null) {
                    Map loas = result.getOrDefault(policyName, new HashMap());
                    Integer count = loas.getOrDefault(loa, 0);
                    loas.put(loa, count + 1);
                    result.put(policyName, loas);
                }
            });
        } while ((decisionPage = this.pdpDecisionRepository.findAll((Pageable)(pageable = new PageRequest(++page, pageSize, Sort.Direction.ASC, new String[]{"id"})))).getNumberOfElements() > 0);
        return result;
    }

    private StatsContext statsContext(PdpDecision decision) {
        try {
            return (StatsContext)objectMapper.readValue(decision.getDecisionJson(), StatsContext.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

