/*
 * Decompiled with CFR 0.152.
 */
package pdp.policies;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import pdp.domain.EntityMetaData;
import pdp.domain.PdpPolicyDefinition;
import pdp.mail.MailBox;
import pdp.manage.Manage;
import pdp.repositories.PdpPolicyRepository;
import pdp.xacml.PdpPolicyDefinitionParser;

public class PolicyMissingServiceProviderValidator {
    private MailBox mailBox;
    private Manage manage;
    private PdpPolicyRepository pdpPolicyRepository;
    private final PdpPolicyDefinitionParser pdpPolicyDefinitionParser = new PdpPolicyDefinitionParser();

    public PolicyMissingServiceProviderValidator(MailBox mailBox, Manage manage, PdpPolicyRepository pdpPolicyRepository) {
        this.mailBox = mailBox;
        this.manage = manage;
        this.pdpPolicyRepository = pdpPolicyRepository;
    }

    public PdpPolicyDefinition addEntityMetaData(PdpPolicyDefinition pd) {
        Optional sp = this.manage.serviceProviderOptionalByEntityId(pd.getServiceProviderId());
        pd.setServiceProviderInvalidOrMissing(!sp.isPresent());
        if (sp.isPresent()) {
            pd.setServiceProviderName(((EntityMetaData)sp.get()).getNameEn());
            pd.setActivatedSr(((EntityMetaData)sp.get()).isPolicyEnforcementDecisionRequired());
        }
        pd.setIdentityProviderNames(this.manage.identityProviderNames(pd.getIdentityProviderIds()));
        return pd;
    }

    public void validate() {
        List invalidPolicies = StreamSupport.stream(this.pdpPolicyRepository.findAll().spliterator(), false).map(policy -> this.addEntityMetaData(this.pdpPolicyDefinitionParser.parse(policy))).filter(policy -> policy.isServiceProviderInvalidOrMissing()).filter(policy -> policy.isActive()).collect(Collectors.toList());
        if (!invalidPolicies.isEmpty()) {
            this.mailBox.sendInvalidPoliciesMail(invalidPolicies);
        }
    }
}

