/*
 * Decompiled with CFR 0.152.
 */
package pdp.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class JsonPolicyRequest {
    @JsonProperty(value="Request")
    public Request request;

    public JsonPolicyRequest() {
    }

    public JsonPolicyRequest(Request request) {
        this.request = request;
    }

    @JsonIgnore
    public void deleteAttribute(String attributeId) {
        this.request.accessSubject.attributes = this.filter(this.request.accessSubject.attributes, attributeId);
        this.request.resource.attributes = this.filter(this.request.resource.attributes, attributeId);
    }

    private List<Attribute> filter(List<Attribute> attributes, String attributeId) {
        return attributes.stream().filter(attr -> !attr.attributeId.equalsIgnoreCase(attributeId)).collect(Collectors.toList());
    }

    @JsonIgnore
    public void addOrReplaceResourceAttribute(String attributeId, String value) {
        this.deleteAttribute(attributeId);
        this.request.resource.attributes.add(new Attribute(attributeId, value));
    }

    @JsonIgnore
    public void addOrReplaceAccessSubjectAttribute(String attributeId, String value) {
        this.deleteAttribute(attributeId);
        this.request.accessSubject.attributes.add(new Attribute(attributeId, value));
    }

    @JsonIgnore
    public JsonPolicyRequest copy() {
        Request requestCopy = new Request();
        requestCopy.combinedDecision = this.request.combinedDecision;
        requestCopy.returnPolicyIdList = this.request.returnPolicyIdList;
        requestCopy.accessSubject.attributes = this.request.accessSubject.attributes.stream().map(attr -> new Attribute(attr.attributeId, attr.value)).collect(Collectors.toList());
        requestCopy.resource.attributes = this.request.resource.attributes.stream().map(attr -> new Attribute(attr.attributeId, attr.value)).collect(Collectors.toList());
        return new JsonPolicyRequest(requestCopy);
    }

    public static class Attribute {
        @JsonProperty(value="AttributeId")
        public String attributeId;
        @JsonProperty(value="Value")
        public String value;

        public Attribute() {
        }

        public Attribute(String attributeId, String value) {
            this.attributeId = attributeId;
            this.value = value;
        }
    }

    public static class AttributeHolder {
        @JsonProperty(value="Attribute")
        public List<Attribute> attributes = new ArrayList<Attribute>();
    }

    public static class Request {
        @JsonProperty(value="ReturnPolicyIdList")
        public boolean returnPolicyIdList;
        @JsonProperty(value="CombinedDecision")
        public boolean combinedDecision;
        @JsonProperty(value="AccessSubject")
        public AttributeHolder accessSubject = new AttributeHolder();
        @JsonProperty(value="Resource")
        public AttributeHolder resource = new AttributeHolder();
    }
}

