/*
 * Decompiled with CFR 0.152.
 */
package pdp.stats;

import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import org.springframework.util.Assert;
import pdp.stats.StatsContext;

public class StatsContextHolder
implements ServletRequestListener {
    private static final ThreadLocal<StatsContext> contextHolder = new ThreadLocal();

    public void requestInitialized(ServletRequestEvent sre) {
        contextHolder.set(new StatsContext());
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        contextHolder.remove();
    }

    public void clearContext() {
        contextHolder.remove();
    }

    public StatsContext getContext() {
        StatsContext ctx = contextHolder.get();
        if (ctx == null) {
            contextHolder.set(new StatsContext());
        }
        return ctx;
    }

    public void setContext(StatsContext context) {
        Assert.notNull((Object)context, (String)"Only non-null StatsContext instances are permitted");
        contextHolder.set(context);
    }
}

