/*
 * Decompiled with CFR 0.152.
 */
package pdp.web;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.servlet.http.HttpServletResponse;
import org.apache.openaz.xacml.api.Decision;
import org.apache.openaz.xacml.api.IdReference;
import org.apache.openaz.xacml.api.Request;
import org.apache.openaz.xacml.api.Response;
import org.apache.openaz.xacml.api.Result;
import org.apache.openaz.xacml.api.pdp.PDPEngine;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.json.JSONRequest;
import org.apache.openaz.xacml.std.json.JSONResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.support.TaskUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pdp.JsonMapper;
import pdp.PdpPolicyException;
import pdp.PolicyNotFoundException;
import pdp.access.FederatedUser;
import pdp.access.PolicyAccess;
import pdp.access.PolicyIdpAccessEnforcer;
import pdp.conflicts.PolicyConflictService;
import pdp.domain.EntityMetaData;
import pdp.domain.JsonPolicyRequest;
import pdp.domain.PdpPolicy;
import pdp.domain.PdpPolicyDefinition;
import pdp.domain.PdpPolicyViolation;
import pdp.mail.MailBox;
import pdp.repositories.PdpPolicyRepository;
import pdp.repositories.PdpPolicyViolationRepository;
import pdp.serviceregistry.ServiceRegistry;
import pdp.util.StreamUtils;
import pdp.xacml.PDPEngineHolder;
import pdp.xacml.PdpPolicyDefinitionParser;
import pdp.xacml.PolicyTemplateEngine;

@RestController
@RequestMapping(headers={"Content-Type=application/json"}, produces={"application/json"})
public class PdpController
implements JsonMapper {
    private static final Logger LOG = LoggerFactory.getLogger(PdpController.class);
    private final PDPEngineHolder pdpEngineHolder;
    private final PdpPolicyViolationRepository pdpPolicyViolationRepository;
    private final PdpPolicyRepository pdpPolicyRepository;
    private final PolicyTemplateEngine policyTemplateEngine = new PolicyTemplateEngine();
    private final PdpPolicyDefinitionParser pdpPolicyDefinitionParser = new PdpPolicyDefinitionParser();
    private final PolicyConflictService policyConflictService = new PolicyConflictService();
    private final ServiceRegistry serviceRegistry;
    private final PolicyIdpAccessEnforcer policyIdpAccessEnforcer;
    private final PDPEngine playgroundPdpEngine;
    private final boolean cachePolicies;
    private final MailBox mailBox;
    private PDPEngine pdpEngine;

    @Autowired
    public PdpController(@Value(value="${period.policies.refresh.minutes}") int period, @Value(value="${policies.cachePolicies}") boolean cachePolicies, PdpPolicyViolationRepository pdpPolicyViolationRepository, PdpPolicyRepository pdpPolicyRepository, PDPEngineHolder pdpEngineHolder, ServiceRegistry serviceRegistry, MailBox mailBox) {
        this.cachePolicies = cachePolicies;
        this.pdpEngineHolder = pdpEngineHolder;
        this.playgroundPdpEngine = pdpEngineHolder.newPdpEngine(false, true);
        this.pdpEngine = pdpEngineHolder.newPdpEngine(cachePolicies, false);
        this.pdpPolicyViolationRepository = pdpPolicyViolationRepository;
        this.policyIdpAccessEnforcer = new PolicyIdpAccessEnforcer(serviceRegistry);
        this.pdpPolicyRepository = pdpPolicyRepository;
        this.serviceRegistry = serviceRegistry;
        this.mailBox = mailBox;
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate((Runnable)TaskUtils.decorateTaskWithErrorHandler(this::refreshPolicies, t -> LOG.error("Exception in refreshPolicies task", t), (boolean)true), period, period, TimeUnit.MINUTES);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/decide/policy"})
    public String decide(@RequestBody String payload) throws Exception {
        return this.doDecide(payload, false);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/internal/decide/policy"})
    public String decideInternal(@RequestBody String payload) throws Exception {
        this.refreshPolicies();
        return this.doDecide(payload, true);
    }

    private String doDecide(String payload, boolean isPlayground) throws Exception {
        long start = System.currentTimeMillis();
        LOG.debug("decide request: {}", (Object)payload);
        Request request = JSONRequest.load((String)payload);
        Response pdpResponse = isPlayground ? this.playgroundPdpEngine.decide(request) : this.pdpEngine.decide(request);
        String response = JSONResponse.toString((Response)pdpResponse, (boolean)LOG.isDebugEnabled());
        LOG.debug("decide response: {} took: {} ms", (Object)response, (Object)(System.currentTimeMillis() - start));
        this.reportPolicyViolation(pdpResponse, response, payload, isPlayground);
        return response;
    }

    @RequestMapping(method={RequestMethod.OPTIONS}, value={"/protected/policies"})
    public ResponseEntity<Void> options(HttpServletResponse response) {
        response.setHeader("Allow", Joiner.on((String)",").join((Iterable)ImmutableList.of((Object)RequestMethod.GET, (Object)RequestMethod.POST, (Object)RequestMethod.PUT, (Object)RequestMethod.DELETE)));
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/policies", "/protected/policies"})
    public List<PdpPolicyDefinition> policyDefinitions() {
        List<PdpPolicyDefinition> policies = StreamSupport.stream(this.pdpPolicyRepository.findAll().spliterator(), false).map(policy -> this.addEntityMetaData(this.addAccessRules((PdpPolicy)policy, this.pdpPolicyDefinitionParser.parse((PdpPolicy)policy)))).collect(Collectors.toList());
        List<Object[]> countPerPolicyId = this.pdpPolicyViolationRepository.findCountPerPolicyId();
        Map<Long, Long> countPerPolicyIdMap = countPerPolicyId.stream().collect(Collectors.toMap(obj -> (Long)obj[0], obj -> (Long)obj[1]));
        policies.forEach(policy -> policy.setNumberOfViolations(countPerPolicyIdMap.getOrDefault(policy.getId(), 0L).intValue()));
        List<Object[]> revisionCountPerId = this.pdpPolicyRepository.findRevisionCountPerId();
        Map<Number, Number> revisionCountPerIdMap = revisionCountPerId.stream().collect(Collectors.toMap(obj -> (Number)obj[0], obj -> (Number)obj[1]));
        policies.forEach(policy -> policy.setNumberOfRevisions(((Number)revisionCountPerIdMap.getOrDefault(policy.getId().intValue(), 0)).intValue()));
        return this.policyIdpAccessEnforcer.filterPdpPolicies(policies);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/conflicts", "/protected/conflicts"})
    public Map<String, List<PdpPolicyDefinition>> conflicts() {
        List<PdpPolicyDefinition> policies = StreamSupport.stream(this.pdpPolicyRepository.findAll().spliterator(), false).map(policy -> this.addEntityMetaData(this.pdpPolicyDefinitionParser.parse((PdpPolicy)policy))).collect(Collectors.toList());
        return this.policyConflictService.conflicts(policies);
    }

    @RequestMapping(method={RequestMethod.PUT, RequestMethod.POST}, value={"/internal/policies", "/protected/policies"})
    public PdpPolicy createPdpPolicy(@RequestBody PdpPolicyDefinition pdpPolicyDefinition) throws DOMStructureException {
        PdpPolicy policy;
        String policyXml = this.policyTemplateEngine.createPolicyXml(pdpPolicyDefinition);
        this.pdpPolicyDefinitionParser.parsePolicy(policyXml);
        if (pdpPolicyDefinition.getId() != null) {
            PdpPolicy fromDB = this.findPolicyById(pdpPolicyDefinition.getId(), PolicyAccess.WRITE);
            policy = fromDB.getParentPolicy() != null ? fromDB.getParentPolicy() : fromDB;
            PdpPolicy.revision(pdpPolicyDefinition.getName(), policy, policyXml, this.policyIdpAccessEnforcer.username(), this.policyIdpAccessEnforcer.authenticatingAuthority(), this.policyIdpAccessEnforcer.userDisplayName(), pdpPolicyDefinition.isActive());
        } else {
            policy = new PdpPolicy(policyXml, pdpPolicyDefinition.getName(), true, this.policyIdpAccessEnforcer.username(), this.policyIdpAccessEnforcer.authenticatingAuthority(), this.policyIdpAccessEnforcer.userDisplayName(), pdpPolicyDefinition.isActive());
            this.policyIdpAccessEnforcer.actionAllowed(policy, PolicyAccess.WRITE, pdpPolicyDefinition.getServiceProviderId(), pdpPolicyDefinition.getIdentityProviderIds());
        }
        try {
            PdpPolicy saved = (PdpPolicy)this.pdpPolicyRepository.save(policy);
            LOG.info("{} PdpPolicy {}", (Object)(policy.getId() != null ? "Updated" : "Created"), (Object)saved.getPolicyXml());
            this.checkConflicts(pdpPolicyDefinition);
            return saved;
        }
        catch (DataIntegrityViolationException e) {
            if (e.getMessage().contains("pdp_policy_name_revision_unique")) {
                throw new PdpPolicyException("name", "Policy name must be unique. " + pdpPolicyDefinition.getName() + " is already taken");
            }
            throw e;
        }
    }

    private void checkConflicts(PdpPolicyDefinition pdpPolicyDefinition) {
        Map<String, List<PdpPolicyDefinition>> conflicts = this.conflicts();
        Optional<EntityMetaData> entityMetaData = this.serviceRegistry.serviceProviderOptionalByEntityId(pdpPolicyDefinition.getServiceProviderId());
        if (entityMetaData.isPresent() && conflicts.containsKey(entityMetaData.get().getNameEn())) {
            this.mailBox.sendConflictsMail(conflicts);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/policies/{id}", "/protected/policies/{id}"})
    public PdpPolicyDefinition policyDefinition(@PathVariable Long id) {
        return this.addEntityMetaData(this.pdpPolicyDefinitionParser.parse(this.findPolicyById(id, PolicyAccess.READ)));
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/internal/policies/{id}", "/protected/policies/{id}"})
    public void deletePdpPolicy(@PathVariable Long id) throws DOMStructureException {
        PdpPolicy policy = this.findPolicyById(id, PolicyAccess.WRITE);
        LOG.info("Deleting PdpPolicy {}", (Object)policy.getName());
        policy = policy.getParentPolicy() != null ? policy.getParentPolicy() : policy;
        this.pdpPolicyRepository.delete(policy);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/default-policy"})
    public PdpPolicyDefinition defaultPolicy() {
        return new PdpPolicyDefinition();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/policies/sp"})
    public List<PdpPolicyDefinition> policyDefinitionsByServiceProvider(@RequestParam String serviceProvider) {
        List<PdpPolicyDefinition> policies = this.policyDefinitions();
        List<PdpPolicyDefinition> filterBySp = StreamSupport.stream(policies.spliterator(), false).filter(policy -> policy.getServiceProviderId().equals(serviceProvider)).collect(Collectors.toList());
        return this.policyIdpAccessEnforcer.filterPdpPolicies(filterBySp);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/violations"})
    public Iterable<PdpPolicyViolation> violations() {
        Iterable violations = this.pdpPolicyViolationRepository.findAll();
        return this.policyIdpAccessEnforcer.filterViolations(violations);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/violations/{id}"})
    public Iterable<PdpPolicyViolation> violationsByPolicyId(@PathVariable Long id) {
        Set<PdpPolicyViolation> violations = this.findPolicyById(id, PolicyAccess.VIOLATIONS).getViolations();
        return this.policyIdpAccessEnforcer.filterViolations(violations);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/revisions/{id}", "/protected/revisions/{id}"})
    public List<PdpPolicyDefinition> revisionsByPolicyId(@PathVariable Long id) {
        PdpPolicy policy = this.findPolicyById(id, PolicyAccess.READ);
        PdpPolicy parent = policy.getParentPolicy() != null ? policy.getParentPolicy() : policy;
        Set<PdpPolicy> policies = parent.getRevisions();
        policies.add(parent);
        return policies.stream().map(rev -> this.addEntityMetaData(this.addAccessRules((PdpPolicy)rev, this.pdpPolicyDefinitionParser.parse((PdpPolicy)rev)))).collect(Collectors.toList());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/attributes", "/protected/attributes"})
    public List<JsonPolicyRequest.Attribute> allowedAttributes() throws IOException {
        InputStream inputStream = new ClassPathResource("xacml/attributes/allowed_attributes.json").getInputStream();
        CollectionType type = objectMapper.getTypeFactory().constructCollectionType(List.class, JsonPolicyRequest.Attribute.class);
        return (List)objectMapper.readValue(inputStream, (JavaType)type);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/internal/saml-attributes"})
    public List<JsonPolicyRequest.Attribute> allowedSamlAttributes() throws IOException {
        InputStream inputStream = new ClassPathResource("xacml/attributes/extra_saml_attributes.json").getInputStream();
        CollectionType type = objectMapper.getTypeFactory().constructCollectionType(List.class, JsonPolicyRequest.Attribute.class);
        List attributes = (List)objectMapper.readValue(inputStream, (JavaType)type);
        attributes.addAll(this.allowedAttributes());
        return attributes;
    }

    private PdpPolicy findPolicyById(Long id, PolicyAccess policyAccess) {
        PdpPolicy policy = (PdpPolicy)this.pdpPolicyRepository.findOne(id);
        if (policy == null) {
            throw new PolicyNotFoundException("PdpPolicy with id " + id + " not found");
        }
        PdpPolicyDefinition definition = this.pdpPolicyDefinitionParser.parse(policy);
        this.policyIdpAccessEnforcer.actionAllowed(policy, policyAccess, definition.getServiceProviderId(), definition.getIdentityProviderIds());
        return policy;
    }

    private PdpPolicyDefinition addAccessRules(PdpPolicy policy, PdpPolicyDefinition pd) {
        boolean actionsAllowed = this.policyIdpAccessEnforcer.actionAllowedIndicator(policy, PolicyAccess.WRITE, pd.getServiceProviderId(), pd.getIdentityProviderIds());
        pd.setActionsAllowed(actionsAllowed);
        pd.setAuthenticatingAuthorityName(this.serviceRegistry.identityProviderByEntityId(policy.getAuthenticatingAuthority()).getNameEn());
        return pd;
    }

    private PdpPolicyDefinition addEntityMetaData(PdpPolicyDefinition pd) {
        EntityMetaData sp = this.serviceRegistry.serviceProviderByEntityId(pd.getServiceProviderId());
        pd.setServiceProviderName(sp.getNameEn());
        pd.setActivatedSr(sp.isPolicyEnforcementDecisionRequired());
        pd.setIdentityProviderNames(this.serviceRegistry.identityProviderNames(pd.getIdentityProviderIds()));
        return pd;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"internal/users/me"})
    public FederatedUser user() {
        return (FederatedUser)((Object)SecurityContextHolder.getContext().getAuthentication().getPrincipal());
    }

    private void reportPolicyViolation(Response pdpResponse, String response, String payload, boolean isPlayground) {
        String policyId;
        Optional policyOptional;
        Optional<IdReference> idReferenceOptional;
        Collection results = pdpResponse.getResults();
        List<Result> deniesOrIndeterminates = results.stream().filter(result -> result.getDecision().equals((Object)Decision.DENY) || result.getDecision().equals((Object)Decision.INDETERMINATE)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(deniesOrIndeterminates) && (idReferenceOptional = this.getPolicyId(deniesOrIndeterminates)).isPresent() && (policyOptional = this.pdpPolicyRepository.findFirstByPolicyIdAndLatestRevision(policyId = idReferenceOptional.get().getId().stringValue(), true).stream().findFirst()).isPresent()) {
            this.pdpPolicyViolationRepository.save(new PdpPolicyViolation((PdpPolicy)policyOptional.get(), payload, response, isPlayground));
        }
    }

    private Optional<IdReference> getPolicyId(List<Result> deniesOrIndeterminates) {
        Result result = deniesOrIndeterminates.get(0);
        Collection policyIdentifiers = result.getPolicyIdentifiers();
        Collection policySetIdentifiers = result.getPolicySetIdentifiers();
        return !CollectionUtils.isEmpty((Collection)policyIdentifiers) ? policyIdentifiers.stream().collect(StreamUtils.singletonOptionalCollector()) : policySetIdentifiers.stream().collect(StreamUtils.singletonOptionalCollector());
    }

    private void refreshPolicies() {
        LOG.info("Starting reloading policies");
        long start = System.currentTimeMillis();
        this.pdpEngine = this.pdpEngineHolder.newPdpEngine(this.cachePolicies, false);
        LOG.info("Finished reloading policies in {} ms", (Object)(System.currentTimeMillis() - start));
    }
}

