/*
 * Decompiled with CFR 0.152.
 */
package pdp.access;

import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;
import pdp.access.FederatedUserBuilder;

public class BasicAuthenticationProvider
implements AuthenticationProvider {
    private final String userName;
    private final String password;

    public BasicAuthenticationProvider(String userName, String password) {
        Assert.notNull((Object)userName);
        Assert.notNull((Object)password);
        this.userName = userName;
        this.password = password;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!this.userName.equals(authentication.getPrincipal())) {
            throw new UsernameNotFoundException("Unknown user: " + authentication.getPrincipal());
        }
        if (!this.password.equals(authentication.getCredentials())) {
            throw new BadCredentialsException("Bad credentials");
        }
        return new UsernamePasswordAuthenticationToken(authentication.getPrincipal(), authentication.getCredentials(), FederatedUserBuilder.apiAuthorities);
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

