/*
 * Decompiled with CFR 0.152.
 */
package pdp.teams;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;
import org.springframework.web.client.RestOperations;
import pdp.teams.VootClient;

@Configuration
public class VootClientConfig {
    public static final String URN_COLLAB_PERSON_EXAMPLE_COM_ADMIN = "urn:collab:person:example.com:admin";
    @Value(value="${voot.accessTokenUri}")
    private String accessTokenUri;
    @Value(value="${voot.userAuthorizationUri}")
    private String userAuthorizationUri;
    @Value(value="${voot.clientId}")
    private String clientId;
    @Value(value="${voot.clientSecret}")
    private String clientSecret;
    @Value(value="${voot.scopes}")
    private String spaceDelimitedScopes;
    @Value(value="${voot.serviceUrl}")
    private String vootServiceUrl;

    @Bean
    @Profile(value={"test", "acc", "prod"})
    public VootClient vootClient() {
        return new VootClient((RestOperations)this.vootRestTemplate(), this.vootServiceUrl);
    }

    @Bean
    @Profile(value={"dev", "perf", "no-csrf", "mail"})
    public VootClient mockVootClient() {
        return new VootClient((RestOperations)this.vootRestTemplate(), this.vootServiceUrl){

            @Override
            public List<String> groups(String userUrn) {
                return VootClientConfig.URN_COLLAB_PERSON_EXAMPLE_COM_ADMIN.equals(userUrn) ? Arrays.asList("urn:collab:group:test.surfteams.nl:nl:surfnet:diensten:managementvo", "urn:collab:group:avans.nl:HRemployees", "urn:collab:group:test.surfteams.nl:nl:surfnet:diensten:managementvo", "urn:collab:group:surfteams.nl:nl:surfnet:diensten:SURFnetWikiAccess") : Collections.emptyList();
            }
        };
    }

    private OAuth2RestTemplate vootRestTemplate() {
        ClientCredentialsResourceDetails details = new ClientCredentialsResourceDetails();
        details.setId("pdp");
        details.setClientId(this.clientId);
        details.setClientSecret(this.clientSecret);
        details.setAccessTokenUri(this.accessTokenUri);
        details.setScope(this.spaceDelimitedScopes != null ? Arrays.asList(this.spaceDelimitedScopes.split(" ")) : Collections.emptyList());
        return new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)details);
    }
}

