/*
 * Decompiled with CFR 0.152.
 */
package pdp;

import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.util.matcher.RequestMatcher;
import pdp.access.BasicAuthenticationProvider;
import pdp.access.PolicyIdpAccessEnforcerFilter;
import pdp.serviceregistry.ServiceRegistry;
import pdp.shibboleth.ShibbolethPreAuthenticatedProcessingFilter;
import pdp.shibboleth.ShibbolethUserDetailService;
import pdp.shibboleth.mock.MockShibbolethFilter;
import pdp.web.CsrfProtectionMatcher;
import pdp.web.CsrfTokenResponseHeaderBindingFilter;

@Configuration
@EnableWebSecurity
@Order(value=1)
public class WebSecurityConfig {
    @Value(value="${policy.enforcement.point.user.name}")
    private String policyEnforcementPointUserName;
    @Value(value="${policy.enforcement.point.user.password}")
    private String policyEnforcementPointPassword;

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        PreAuthenticatedAuthenticationProvider authenticationProvider = new PreAuthenticatedAuthenticationProvider();
        authenticationProvider.setPreAuthenticatedUserDetailsService((AuthenticationUserDetailsService)new ShibbolethUserDetailService());
        auth.authenticationProvider((AuthenticationProvider)authenticationProvider);
        BasicAuthenticationProvider basicAuthenticationProvider = new BasicAuthenticationProvider(this.policyEnforcementPointUserName, this.policyEnforcementPointPassword);
        auth.authenticationProvider((AuthenticationProvider)basicAuthenticationProvider);
    }

    @Configuration
    @Order
    public static class ApiSecurityConfigurationAdapter
    extends WebSecurityConfigurerAdapter {
        @Autowired
        private ServiceRegistry serviceRegistry;

        protected void configure(HttpSecurity http) throws Exception {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.antMatcher("/**").sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).csrf().disable()).addFilterBefore((Filter)new PolicyIdpAccessEnforcerFilter(this.authenticationManager(), this.serviceRegistry), BasicAuthenticationFilter.class).authorizeRequests().antMatchers(new String[]{"/protected/**", "/decide/policy"})).hasAnyRole(new String[]{"PEP", "ADMIN"});
        }
    }

    @Order(value=2)
    @Configuration
    public static class InternalSecurityConfigurationAdapter
    extends WebSecurityConfigurerAdapter {
        @Autowired
        private ServiceRegistry serviceRegistry;
        @Autowired
        private Environment environment;

        public void configure(WebSecurity web) throws Exception {
            web.ignoring().antMatchers(new String[]{"/health/**", "/info/**", "/public/**"});
        }

        protected void configure(HttpSecurity http) throws Exception {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.antMatcher("/internal/**").sessionManagement().sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED).and()).csrf().requireCsrfProtectionMatcher((RequestMatcher)new CsrfProtectionMatcher()).and()).addFilterAfter((Filter)new CsrfTokenResponseHeaderBindingFilter(), CsrfFilter.class).addFilterAfter((Filter)new ShibbolethPreAuthenticatedProcessingFilter(this.authenticationManagerBean(), this.serviceRegistry), AbstractPreAuthenticatedProcessingFilter.class).authorizeRequests().antMatchers(new String[]{"/internal/**"})).hasAnyRole(new String[]{"PEP", "ADMIN"});
            if (this.environment.acceptsProfiles(new String[]{"no-csrf"})) {
                http.csrf().disable();
            }
            if (this.environment.acceptsProfiles(new String[]{"dev", "perf"})) {
                http.addFilterBefore((Filter)new MockShibbolethFilter(), ShibbolethPreAuthenticatedProcessingFilter.class);
            }
        }
    }
}

