/*
 * Decompiled with CFR 0.152.
 */
package pdp.access;

import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import pdp.access.FederatedUser;
import pdp.access.FederatedUserBuilder;
import pdp.access.PolicyIdpAccessAwareToken;
import pdp.access.RunAsFederatedUser;
import pdp.serviceregistry.ServiceRegistry;

public class PolicyIdpAccessEnforcerFilter
extends BasicAuthenticationFilter {
    private final FederatedUserBuilder federatedUserBuilder;

    public PolicyIdpAccessEnforcerFilter(AuthenticationManager authenticationManager, ServiceRegistry serviceRegsitry) {
        super(authenticationManager);
        this.federatedUserBuilder = new FederatedUserBuilder(serviceRegsitry);
    }

    protected void onSuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException {
        Optional<FederatedUser> runAsFederatedUserOptional = this.federatedUserBuilder.basicAuthUser(request, authResult.getAuthorities());
        if (runAsFederatedUserOptional.isPresent()) {
            SecurityContextHolder.getContext().setAuthentication((Authentication)new PolicyIdpAccessAwareToken((RunAsFederatedUser)runAsFederatedUserOptional.get()));
        }
    }
}

