/*
 * Decompiled with CFR 0.152.
 */
package pdp.policies;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import pdp.domain.PdpPolicy;
import pdp.policies.PolicyLoader;
import pdp.repositories.PdpPolicyRepository;
import pdp.repositories.PdpPolicyViolationRepository;
import pdp.xacml.PolicyTemplateEngine;

public class DevelopmentPrePolicyLoader
implements PolicyLoader {
    private static Logger LOG = LoggerFactory.getLogger(DevelopmentPrePolicyLoader.class);
    private final Resource baseDirResource;
    private final PdpPolicyRepository pdpPolicyRepository;
    private final PdpPolicyViolationRepository pdpPolicyViolationRepository;

    public DevelopmentPrePolicyLoader(Resource baseDirResource, PdpPolicyRepository pdpPolicyRepository, PdpPolicyViolationRepository pdpPolicyViolationRepository) {
        this.pdpPolicyRepository = pdpPolicyRepository;
        this.pdpPolicyViolationRepository = pdpPolicyViolationRepository;
        this.baseDirResource = baseDirResource;
        Assert.isTrue((boolean)this.baseDirResource.exists());
    }

    @Override
    public List<PdpPolicy> getPolicies() throws IOException {
        return Arrays.stream(this.baseDirResource.getFile().listFiles((dir, name) -> name.endsWith("xml"))).map(file -> this.createPdpPolicy(this.getXml((File)file), file.getName())).collect(Collectors.toList());
    }

    @Override
    public void loadPolicies() throws IOException {
        this.pdpPolicyViolationRepository.deleteAll();
        this.pdpPolicyRepository.deleteAll();
        this.getPolicies().forEach(policy -> {
            this.pdpPolicyRepository.save(policy);
            LOG.info("Loaded {} policy", (Object)policy.getName());
        });
    }

    public String fileNameToPolicyName(String fileName) {
        return fileName.replaceAll("(\\.|xml)", "").replaceAll("([A-Z])", " $1").toLowerCase();
    }

    private PdpPolicy createPdpPolicy(String xml, String fileName) {
        String name = this.fileNameToPolicyName(fileName);
        xml = xml.replaceFirst("PolicyId=\".*\"", "PolicyId=\"" + PolicyTemplateEngine.getPolicyId(name) + "\"");
        return new PdpPolicy(xml, name, true, "system", "http://mock-idp", "system", true);
    }

    private String getXml(File file) {
        try {
            return IOUtils.toString((InputStream)new FileInputStream(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

