/*
 * Decompiled with CFR 0.152.
 */
package pdp.stats;

import com.fasterxml.jackson.core.JsonProcessingException;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import pdp.JsonMapper;
import pdp.domain.PdpDecision;
import pdp.repositories.PdpDecisionRepository;
import pdp.stats.StatsContext;

public class StatsContextHolder
implements ServletRequestListener,
JsonMapper {
    private static final ThreadLocal<StatsContext> contextHolder = new ThreadLocal();
    private final String path;
    private final PdpDecisionRepository decisionRepository;

    public StatsContextHolder(String path, PdpDecisionRepository decisionRepository) {
        this.path = path;
        this.decisionRepository = decisionRepository;
    }

    public void requestInitialized(ServletRequestEvent sre) {
        if (this.applyForPath(sre)) {
            contextHolder.set(new StatsContext());
        }
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        if (this.applyForPath(sre)) {
            StatsContext context = contextHolder.get();
            new Thread(() -> this.saveContext(context)).start();
            contextHolder.remove();
        }
    }

    private void saveContext(StatsContext context) {
        if (context.getServiceProvicer() == null) {
            return;
        }
        try {
            PdpDecision pdpDecision = new PdpDecision();
            pdpDecision.setDecisionJson(objectMapper.writeValueAsString((Object)context));
            this.decisionRepository.save(pdpDecision);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean applyForPath(ServletRequestEvent sre) {
        return ((HttpServletRequest)sre.getServletRequest()).getRequestURI().endsWith(this.path);
    }

    public static StatsContext getContext() {
        StatsContext ctx = contextHolder.get();
        if (ctx == null) {
            contextHolder.set(new StatsContext());
        }
        return contextHolder.get();
    }
}

