/*
 * Decompiled with CFR 0.152.
 */
package pdp.policies;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import pdp.domain.EntityMetaData;
import pdp.domain.PdpPolicy;
import pdp.domain.PdpPolicyDefinition;
import pdp.mail.MailBox;
import pdp.repositories.PdpPolicyRepository;
import pdp.serviceregistry.ServiceRegistry;
import pdp.xacml.PdpPolicyDefinitionParser;

public class PolicyMissingServiceProviderValidator {
    private MailBox mailBox;
    private ServiceRegistry serviceRegistry;
    private PdpPolicyRepository pdpPolicyRepository;
    private final PdpPolicyDefinitionParser pdpPolicyDefinitionParser = new PdpPolicyDefinitionParser();

    public PolicyMissingServiceProviderValidator(MailBox mailBox, ServiceRegistry serviceRegistry, PdpPolicyRepository pdpPolicyRepository) {
        this.mailBox = mailBox;
        this.serviceRegistry = serviceRegistry;
        this.pdpPolicyRepository = pdpPolicyRepository;
    }

    private PdpPolicyDefinition addEntityMetaData(PdpPolicyDefinition pd) {
        Optional<EntityMetaData> sp = this.serviceRegistry.serviceProviderOptionalByEntityId(pd.getServiceProviderId());
        pd.setServiceProviderInvalidOrMissing(!sp.isPresent());
        if (sp.isPresent()) {
            pd.setServiceProviderName(sp.get().getNameEn());
            pd.setActivatedSr(sp.get().isPolicyEnforcementDecisionRequired());
        }
        pd.setIdentityProviderNames(this.serviceRegistry.identityProviderNames(pd.getIdentityProviderIds()));
        return pd;
    }

    public void validate() {
        List<PdpPolicyDefinition> invalidPolicies = StreamSupport.stream(this.pdpPolicyRepository.findAll().spliterator(), false).map(policy -> this.addEntityMetaData(this.pdpPolicyDefinitionParser.parse((PdpPolicy)policy))).filter(policy -> policy.isServiceProviderInvalidOrMissing()).filter(policy -> policy.isActive()).collect(Collectors.toList());
        if (!invalidPolicies.isEmpty()) {
            this.mailBox.sendInvalidPoliciesMail(invalidPolicies);
            invalidPolicies.forEach(policyDefinition -> {
                PdpPolicy pdpPolicy = (PdpPolicy)this.pdpPolicyRepository.findOne(policyDefinition.getId());
                pdpPolicy.setActive(false);
                this.pdpPolicyRepository.save(pdpPolicy);
            });
        }
    }
}

