/*
 * Decompiled with CFR 0.152.
 */
package pdp.web;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class CsrfProtectionMatcher
implements RequestMatcher {
    private final Pattern allowedMethods = Pattern.compile("^(GET|HEAD|TRACE|OPTIONS)$");
    private final List<String> trustedApiHttpHeaders = Arrays.asList("X-IDP-ENTITY-ID", "X-UNSPECIFIED-NAME-ID", "X-DISPLAY-NAME");

    public boolean matches(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        return servletPath.startsWith("/internal") && !servletPath.equalsIgnoreCase("/internal/jsError") && !this.isTrustedApiRequest(request) && !this.allowedMethods.matcher(request.getMethod().toUpperCase()).matches();
    }

    private boolean isTrustedApiRequest(HttpServletRequest request) {
        return this.trustedApiHttpHeaders.stream().map(s -> request.getHeader(s)).allMatch(v -> v != null);
    }
}

