/*
 * Decompiled with CFR 0.152.
 */
package pdp.conflicts;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.util.CollectionUtils;
import pdp.domain.PdpPolicyDefinition;

public class PolicyConflictService {
    public Map<String, List<PdpPolicyDefinition>> conflicts(List<PdpPolicyDefinition> policies) {
        HashSet conflicts = new HashSet();
        IntStream.range(0, policies.size()).forEach(i -> IntStream.range(i + 1, policies.size()).forEach(j -> {
            PdpPolicyDefinition two;
            PdpPolicyDefinition one = (PdpPolicyDefinition)policies.get(i);
            if (this.conflict(one, two = (PdpPolicyDefinition)policies.get(j))) {
                conflicts.addAll(Arrays.asList(one, two));
            }
        }));
        return conflicts.stream().filter(conflict -> !conflict.isServiceProviderInvalidOrMissing()).collect(Collectors.groupingBy(PdpPolicyDefinition::getServiceProviderName));
    }

    private boolean conflict(PdpPolicyDefinition one, PdpPolicyDefinition two) {
        return one.getServiceProviderId().equals(two.getServiceProviderId()) && (CollectionUtils.isEmpty((Collection)one.getIdentityProviderIds()) || CollectionUtils.isEmpty((Collection)two.getIdentityProviderIds()) || this.overlapping(one.getIdentityProviderIds(), two.getIdentityProviderIds()));
    }

    private boolean overlapping(List<String> idps, List<String> otherIdps) {
        return otherIdps.stream().map(idp -> idps.stream().anyMatch(s -> s.equals(idp))).anyMatch(b -> b);
    }
}

