/*
 * Decompiled with CFR 0.152.
 */
package pdp.mail;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import pdp.JsonMapper;
import pdp.domain.PdpPolicyDefinition;
import pdp.mail.MailBox;

public class DefaultMailBox
implements MailBox,
JsonMapper {
    @Autowired
    private JavaMailSender mailSender;
    private final String baseUrl;
    private final String to;
    private final String from;

    public DefaultMailBox(String baseUrl, String to, String from) {
        this.baseUrl = baseUrl;
        this.to = to;
        this.from = from;
    }

    public void sendConflictsMail(Map<String, List<PdpPolicyDefinition>> conflicts) {
        try {
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("@@to@@", this.to);
            variables.put("@@conflicts@@", this.objectToTable(conflicts));
            variables.put("@@base_url@@", this.baseUrl);
            this.sendMail("mail/conflicts.html", "PDP Conflicts", variables);
        }
        catch (IOException | MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendInvalidPoliciesMail(List<PdpPolicyDefinition> invalids) {
        try {
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("@@to@@", this.to);
            variables.put("@@invalids@@", this.objectToTable(invalids));
            variables.put("@@base_url@@", this.baseUrl);
            this.sendMail("mail/invalids.html", "PDP Invalid Policies", variables);
        }
        catch (IOException | MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    private String objectToTable(Object arg) throws JsonProcessingException {
        return "<pre>" + objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(arg) + "</pre>";
    }

    private void sendMail(String templateName, String subject, Map<String, String> variables) throws MessagingException, IOException {
        String html = IOUtils.toString((InputStream)new ClassPathResource(templateName).getInputStream());
        for (Map.Entry<String, String> var : variables.entrySet()) {
            String value = var.getValue();
            value = value.replaceAll("\\$", "\\\\\\$");
            html = html.replaceAll(var.getKey(), value);
        }
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        helper.setSubject(subject);
        helper.setTo(this.to);
        this.setText(html, helper);
        helper.setFrom(this.from);
        this.doSendMail(message);
    }

    protected void setText(String html, MimeMessageHelper helper) throws MessagingException {
        helper.setText(html, true);
    }

    protected void doSendMail(MimeMessage message) {
        new Thread(() -> this.mailSender.send(message)).start();
    }
}

