/*
 * Decompiled with CFR 0.152.
 */
package pdp.xacml;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.pip.PIPEngine;
import org.apache.openaz.xacml.api.pip.PIPException;
import org.apache.openaz.xacml.api.pip.PIPFinder;
import org.apache.openaz.xacml.api.pip.PIPRequest;
import org.apache.openaz.xacml.api.pip.PIPResponse;
import org.apache.openaz.xacml.std.IdentifierImpl;
import org.apache.openaz.xacml.std.StdAttribute;
import org.apache.openaz.xacml.std.StdAttributeValue;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.pip.StdMutablePIPResponse;
import org.apache.openaz.xacml.std.pip.StdPIPRequest;
import org.apache.openaz.xacml.std.pip.StdSinglePIPResponse;
import org.apache.openaz.xacml.std.pip.engines.ConfigurableEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import pdp.stats.StatsContext;
import pdp.stats.StatsContextHolder;

public abstract class AbstractConfigurableEngine
implements ConfigurableEngine {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    protected PIPRequest requiredAttribute;
    protected PIPRequest providedAttribute;
    protected PIPResponse empty;
    protected PIPResponse missingNameId;

    public void configure(String id, Properties properties) throws PIPException {
        IdentifierImpl identifierDataType = new IdentifierImpl("http://www.w3.org/2001/XMLSchema#string");
        IdentifierImpl attributeCategory = new IdentifierImpl("urn:oasis:names:tc:xacml:1.0:subject-category:access-subject");
        this.requiredAttribute = this.requiredAttribute(identifierDataType, attributeCategory);
        IdentifierImpl identifierAttribute = new IdentifierImpl(this.getIdentifierProvidedAttribute());
        this.providedAttribute = this.providedAttribute(identifierDataType, attributeCategory, identifierAttribute);
        StdAttribute attribute = new StdAttribute((Identifier)attributeCategory, (Identifier)identifierAttribute, Collections.emptyList(), null, true);
        this.empty = new StdSinglePIPResponse((Attribute)attribute);
        this.missingNameId = new StdMutablePIPResponse((Status)new StdStatus(StdStatusCode.STATUS_CODE_MISSING_ATTRIBUTE, "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified attribute missing"));
    }

    protected StdPIPRequest providedAttribute(IdentifierImpl identifierDataType, IdentifierImpl attributeCategory, IdentifierImpl identifierAttribute) {
        return new StdPIPRequest((Identifier)attributeCategory, (Identifier)identifierAttribute, (Identifier)identifierDataType);
    }

    protected StdPIPRequest requiredAttribute(IdentifierImpl identifierDataType, IdentifierImpl attributeCategory) {
        return new StdPIPRequest((Identifier)attributeCategory, (Identifier)new IdentifierImpl("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"), (Identifier)identifierDataType);
    }

    public Collection<PIPRequest> attributesRequired() {
        return Arrays.asList(this.requiredAttribute);
    }

    public Collection<PIPRequest> attributesProvided() {
        return Arrays.asList(this.providedAttribute);
    }

    public PIPResponse getAttributes(PIPRequest pipRequest, PIPFinder pipFinder) throws PIPException {
        if (!this.getIdentifierProvidedAttribute().equals(pipRequest.getAttributeId().getUri().toString())) {
            return this.empty;
        }
        PIPResponse matchingAttributes = pipFinder.getMatchingAttributes(this.requiredAttribute, (PIPEngine)this);
        Optional nameAttributeOptional = matchingAttributes.getAttributes().stream().findFirst();
        if (!nameAttributeOptional.isPresent()) {
            return this.missingNameId;
        }
        Attribute nameAttribute = (Attribute)nameAttributeOptional.get();
        Collection values = nameAttribute.getValues();
        if (CollectionUtils.isEmpty((Collection)values)) {
            return this.missingNameId;
        }
        String userUrn = (String)((AttributeValue)values.stream().findFirst().get()).getValue();
        StatsContext stats = StatsContextHolder.getContext();
        long start = System.currentTimeMillis();
        List result = this.getAttributes(userUrn);
        long ms = System.currentTimeMillis() - start;
        stats.addPipResponse(this.getName(), ms);
        this.LOG.info("{} PIP response for {} took {} ms", new Object[]{this.getName(), userUrn, ms});
        if (CollectionUtils.isEmpty((Collection)result)) {
            return this.empty;
        }
        Identifier dataTypeId = this.providedAttribute.getDataTypeId();
        List stdAttributeValues = result.stream().map(valueIn -> new StdAttributeValue(dataTypeId, valueIn)).collect(Collectors.toList());
        StdAttribute responseAttr = new StdAttribute(this.providedAttribute.getCategory(), this.providedAttribute.getAttributeId(), stdAttributeValues, null, true);
        this.LOG.debug("Returning result from PIP {}: {}", (Object)this.getName(), (Object)result);
        return new StdSinglePIPResponse((Attribute)responseAttr);
    }

    protected abstract List<Object> getAttributes(String var1);

    public abstract String getIdentifierProvidedAttribute();
}

