/*
 * Decompiled with CFR 0.152.
 */
package pdp.access;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.util.StringUtils;
import pdp.access.FederatedUser;
import pdp.access.PolicyIdpAccessUnknownIdentityProvidersException;
import pdp.access.RunAsFederatedUser;
import pdp.domain.EntityMetaData;
import pdp.manage.Manage;

public class FederatedUserBuilder {
    private static final Collection<? extends GrantedAuthority> shibAuthorities = AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER", "ROLE_ADMIN"});
    public static final Collection<? extends GrantedAuthority> apiAuthorities = AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER", "ROLE_PEP"});
    public static final String UID_HEADER_NAME = "uid";
    public static final String DISPLAY_NAME_HEADER_NAME = "displayname";
    public static final String SHIB_AUTHENTICATING_AUTHORITY = "Shib-Authenticating-Authority";
    public static final String X_IDP_ENTITY_ID = "X-IDP-ENTITY-ID";
    public static final String X_UNSPECIFIED_NAME_ID = "X-UNSPECIFIED-NAME-ID";
    public static final String X_DISPLAY_NAME = "X-DISPLAY-NAME";
    public static final String X_IMPERSONATE = "X-IMPERSONATE";
    private static final Logger LOG = LoggerFactory.getLogger(FederatedUserBuilder.class);
    private final Manage manage;

    public FederatedUserBuilder(Manage manage) {
        this.manage = manage;
    }

    public Optional<FederatedUser> basicAuthUser(HttpServletRequest request, Collection<? extends GrantedAuthority> authorities) {
        String idpEntityId = request.getHeader(X_IDP_ENTITY_ID);
        String nameId = request.getHeader(X_UNSPECIFIED_NAME_ID);
        String displayName = request.getHeader(X_DISPLAY_NAME);
        if (StringUtils.isEmpty((Object)idpEntityId) || StringUtils.isEmpty((Object)nameId) || StringUtils.isEmpty((Object)displayName)) {
            return Optional.empty();
        }
        Set idpEntities = this.manage.identityProvidersByAuthenticatingAuthority(idpEntityId);
        Set spEntities = this.getSpEntities(idpEntities);
        LOG.debug("Creating RunAsFederatedUser {}", (Object)nameId);
        return Optional.of(new RunAsFederatedUser(nameId, idpEntityId, displayName, idpEntities, spEntities, authorities));
    }

    public Optional<FederatedUser> shibUser(HttpServletRequest request) {
        Set idpEntities;
        String uid = request.getHeader(UID_HEADER_NAME);
        String displayName = request.getHeader(DISPLAY_NAME_HEADER_NAME);
        String authenticatingAuthority = request.getHeader(SHIB_AUTHENTICATING_AUTHORITY);
        if (StringUtils.isEmpty((Object)uid) || StringUtils.isEmpty((Object)displayName) || StringUtils.isEmpty((Object)authenticatingAuthority)) {
            return Optional.empty();
        }
        authenticatingAuthority = authenticatingAuthority.split(";")[0];
        try {
            idpEntities = this.manage.identityProvidersByAuthenticatingAuthority(authenticatingAuthority);
        }
        catch (PolicyIdpAccessUnknownIdentityProvidersException e) {
            return Optional.empty();
        }
        Set spEntities = this.getSpEntities(idpEntities);
        LOG.debug("Creating FederatedUser {}", (Object)uid);
        return Optional.of(new FederatedUser(uid, authenticatingAuthority, displayName, idpEntities, spEntities, shibAuthorities));
    }

    private Set<EntityMetaData> getSpEntities(Set<EntityMetaData> idpEntities) {
        String institutionId = idpEntities.iterator().next().getInstitutionId();
        return this.manage.serviceProvidersByInstitutionId(institutionId);
    }
}

