/*
 * Decompiled with CFR 0.152.
 */
package pdp.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.util.CollectionUtils;
import pdp.domain.LoA;
import pdp.domain.PdpAttribute;
import pdp.xacml.PolicyTemplateEngine;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PdpPolicyDefinition {
    private Long id;
    @NotNull
    @Size(min=1)
    private String name;
    @NotNull
    @Size(min=1)
    private String description;
    @NotNull
    @Size(min=1)
    private String serviceProviderId;
    private String serviceProviderName;
    private String serviceProviderNameNl;
    private boolean serviceProviderInvalidOrMissing;
    private List<String> identityProviderIds = new ArrayList();
    private List<String> identityProviderNames = new ArrayList();
    private List<String> identityProviderNamesNl = new ArrayList();
    private String clientId;
    @Valid
    private List<PdpAttribute> attributes = new ArrayList();
    @Valid
    private List<LoA> loas = new ArrayList();
    private String denyAdvice;
    private boolean denyRule;
    private boolean allAttributesMustMatch;
    @JsonIgnore
    private Date created;
    private String userDisplayName;
    private String authenticatingAuthorityName;
    private int numberOfViolations;
    private int numberOfRevisions;
    private String denyAdviceNl;
    private int revisionNbr;
    private boolean isActivatedSr;
    private boolean active;
    private boolean actionsAllowed;
    private String type;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getServiceProviderId() {
        return this.serviceProviderId;
    }

    public void setServiceProviderId(String serviceProviderId) {
        this.serviceProviderId = serviceProviderId;
    }

    public List<String> getIdentityProviderIds() {
        return this.identityProviderIds;
    }

    public void setIdentityProviderIds(List<String> identityProviderIds) {
        this.identityProviderIds = identityProviderIds;
    }

    public List<PdpAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<PdpAttribute> attributes) {
        this.attributes = attributes;
    }

    public List<LoA> getLoas() {
        return this.loas;
    }

    public void setLoas(List<LoA> loas) {
        this.loas = loas;
    }

    public String getDenyAdvice() {
        return this.denyAdvice;
    }

    public void setDenyAdvice(String denyAdvice) {
        this.denyAdvice = denyAdvice;
    }

    public boolean isDenyRule() {
        return this.denyRule;
    }

    public void setDenyRule(boolean denyRule) {
        this.denyRule = denyRule;
    }

    public boolean isAllAttributesMustMatch() {
        return this.allAttributesMustMatch;
    }

    public void setAllAttributesMustMatch(boolean allAttributesMustMatch) {
        this.allAttributesMustMatch = allAttributesMustMatch;
    }

    public String getPolicyId() {
        return PolicyTemplateEngine.getPolicyId((String)this.name);
    }

    public String getServiceProviderName() {
        return this.serviceProviderName;
    }

    public void setServiceProviderName(String serviceProviderName) {
        this.serviceProviderName = serviceProviderName;
    }

    public boolean isServiceProviderInvalidOrMissing() {
        return this.serviceProviderInvalidOrMissing;
    }

    public void setServiceProviderInvalidOrMissing(boolean serviceProviderInvalidOrMissing) {
        this.serviceProviderInvalidOrMissing = serviceProviderInvalidOrMissing;
    }

    public List<String> getIdentityProviderNames() {
        return this.identityProviderNames;
    }

    public void setIdentityProviderNames(List<String> identityProviderNames) {
        this.identityProviderNames = identityProviderNames;
    }

    public List<String> getIdentityProviderNamesNl() {
        return this.identityProviderNamesNl;
    }

    public void setIdentityProviderNamesNl(List<String> identityProviderNamesNl) {
        this.identityProviderNamesNl = identityProviderNamesNl;
    }

    public int getNumberOfViolations() {
        return this.numberOfViolations;
    }

    public void setNumberOfViolations(int numberOfViolations) {
        this.numberOfViolations = numberOfViolations;
    }

    public void setDenyAdviceNl(String denyAdviceNl) {
        this.denyAdviceNl = denyAdviceNl;
    }

    public String getDenyAdviceNl() {
        return this.denyAdviceNl;
    }

    public int getNumberOfRevisions() {
        return this.numberOfRevisions;
    }

    public void setNumberOfRevisions(int numberOfRevisions) {
        this.numberOfRevisions = numberOfRevisions;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @JsonProperty
    public Date getCreated() {
        return this.created;
    }

    @JsonIgnore
    public void setCreated(Date created) {
        this.created = created;
    }

    public String getUserDisplayName() {
        return this.userDisplayName;
    }

    public void setUserDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
    }

    public void setRevisionNbr(int revisionNbr) {
        this.revisionNbr = revisionNbr;
    }

    public int getRevisionNbr() {
        return this.revisionNbr;
    }

    public boolean isActivatedSr() {
        return this.isActivatedSr;
    }

    public void setActivatedSr(boolean activatedSr) {
        this.isActivatedSr = activatedSr;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActionsAllowed() {
        return this.actionsAllowed;
    }

    public void setActionsAllowed(boolean actionsAllowed) {
        this.actionsAllowed = actionsAllowed;
    }

    public String getAuthenticatingAuthorityName() {
        return this.authenticatingAuthorityName;
    }

    public void setAuthenticatingAuthorityName(String authenticatingAuthorityName) {
        this.authenticatingAuthorityName = authenticatingAuthorityName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    @JsonIgnore
    public List<String> anyIdentityProviders() {
        return CollectionUtils.isEmpty((Collection)this.identityProviderIds) ? Collections.emptyList() : Arrays.asList("will-iterate-once");
    }

    @JsonIgnore
    public Set<Map.Entry<String, List<PdpAttribute>>> allAttributesGrouped() {
        return this.attributes.stream().collect(Collectors.groupingBy(PdpAttribute::getName)).entrySet();
    }

    @JsonIgnore
    public boolean isIdpOnly() {
        return !this.identityProviderIds.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdpPolicyDefinition that = (PdpPolicyDefinition)o;
        return Objects.equals(this.denyRule, that.denyRule) && Objects.equals(this.allAttributesMustMatch, that.allAttributesMustMatch) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.serviceProviderId, that.serviceProviderId) && Objects.equals(this.identityProviderIds, that.identityProviderIds) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.denyAdvice, that.denyAdvice) && Objects.equals(this.denyAdviceNl, that.denyAdviceNl);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.serviceProviderId, this.identityProviderIds, this.attributes, this.denyAdvice, this.denyRule, this.allAttributesMustMatch);
    }

    public String toString() {
        return "PdpPolicyDefinition{\nname='" + this.name + '\'' + "\n, description='" + this.description + '\'' + "\n, serviceProviderId='" + this.serviceProviderId + '\'' + "\n, identityProviderIds=" + this.identityProviderIds + "\n, attributes=" + this.attributes + "\n, denyAdvice='" + this.denyAdvice + '\'' + "\n, denyAdviceNl='" + this.denyAdviceNl + '\'' + "\n, denyRule=" + this.denyRule + "\n, allAttributesMustMatch=" + this.allAttributesMustMatch + "\n" + '}';
    }

    public static PdpPolicyDefinition policyDefinition(String serviceProviderId, List<String> identityProvidersIds) {
        PdpPolicyDefinition definition = new PdpPolicyDefinition();
        definition.setServiceProviderId(serviceProviderId);
        definition.setServiceProviderName(serviceProviderId);
        definition.setIdentityProviderIds(identityProvidersIds);
        definition.setType("reg");
        return definition;
    }

    @JsonIgnore
    public void sortLoas() {
        Collections.sort(this.loas, Comparator.comparing(LoA::getLevel).reversed());
    }

    public void setServiceProviderNameNl(String serviceProviderNameNl) {
        this.serviceProviderNameNl = serviceProviderNameNl;
    }

    public String getServiceProviderNameNl() {
        return this.serviceProviderNameNl;
    }
}

