/*
 * Decompiled with CFR 0.152.
 */
package pdp.teams;

import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestOperations;

public class VootClient {
    private static final Logger LOG = LoggerFactory.getLogger(VootClient.class);
    private final String vootServiceUrl;
    private final RestOperations vootService;

    public VootClient(RestOperations vootService, String vootServiceUrl) {
        this.vootService = vootService;
        this.vootServiceUrl = vootServiceUrl;
    }

    public List<String> groups(String userUrn) {
        long start = System.currentTimeMillis();
        LOG.info("Starting to retrieve groups for {}", (Object)userUrn);
        List groups = (List)this.vootService.getForObject(this.vootServiceUrl + "/internal/groups/{userUrn}", List.class, new Object[]{userUrn});
        LOG.debug("Retrieved groups: {}", (Object)groups);
        LOG.info("finished retrieving groups for {} in {} ms", (Object)userUrn, (Object)(System.currentTimeMillis() - start));
        return groups.stream().map(entry -> (String)entry.get("id")).collect(Collectors.toList());
    }
}

