/*
 * Decompiled with CFR 0.152.
 */
package pdp.manage;

import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import pdp.domain.EntityMetaData;
import pdp.domain.PdpPolicyDefinition;
import pdp.manage.Manage;
import pdp.util.StreamUtils;

public class ClassPathResourceManage
implements Manage {
    private Map<String, List<EntityMetaData>> entityMetaData = new ConcurrentHashMap();

    public ClassPathResourceManage() {
        this.initializeMetadata();
    }

    private void initializeMetadata() {
        ConcurrentHashMap<String, List> newEntityMetaData = new ConcurrentHashMap<String, List>();
        newEntityMetaData.put("IDPentityID", this.parseEntities(this.getIdpResource()));
        newEntityMetaData.put("SPentityID", this.parseEntities(this.getSpResource()));
        this.entityMetaData = newEntityMetaData;
        LOG.debug("Initialized Manage Resources. Number of IDPs {}. Number of SPs {}", (Object)((List)this.entityMetaData.get("IDPentityID")).size(), (Object)((List)this.entityMetaData.get("SPentityID")).size());
    }

    private Resource getIdpResource() {
        return new ClassPathResource("manage/identity-providers.json");
    }

    private Resource getSpResource() {
        return new ClassPathResource("manage/service-providers.json");
    }

    public List<EntityMetaData> serviceProviders() {
        return (List)this.entityMetaData.get("SPentityID");
    }

    public List<EntityMetaData> identityProviders() {
        return (List)this.entityMetaData.get("IDPentityID");
    }

    public Set<EntityMetaData> identityProvidersByAuthenticatingAuthority(String authenticatingAuthority) {
        EntityMetaData idp = this.identityProviderByEntityId(authenticatingAuthority);
        String institutionId = idp.getInstitutionId();
        if (StringUtils.hasText((String)institutionId)) {
            return this.identityProviders().stream().filter(md -> institutionId.equals(md.getInstitutionId())).collect(Collectors.toSet());
        }
        return Sets.newHashSet((Object[])new EntityMetaData[]{idp});
    }

    public Set<EntityMetaData> serviceProvidersByInstitutionId(String institutionId) {
        if (StringUtils.isEmpty((Object)institutionId)) {
            return Collections.emptySet();
        }
        return this.serviceProviders().stream().filter(sp -> institutionId.equals(sp.getInstitutionId())).collect(Collectors.toSet());
    }

    public Optional<EntityMetaData> serviceProviderOptionalByEntityId(String entityId) {
        return this.entityMetaDataOptionalByEntityId(entityId, this.serviceProviders());
    }

    public Optional<EntityMetaData> identityProviderOptionalByEntityId(String entityId) {
        return this.entityMetaDataOptionalByEntityId(entityId, this.identityProviders());
    }

    private Optional<EntityMetaData> entityMetaDataOptionalByEntityId(String entityId, List<EntityMetaData> entityMetaDatas) {
        return (Optional)entityMetaDatas.stream().filter(sp -> sp.getEntityId().equals(entityId)).collect(StreamUtils.singletonOptionalCollector());
    }

    public EntityMetaData serviceProviderByEntityId(String entityId) {
        return this.nonEmptyOptionalToEntityMetaData(entityId, this.serviceProviderOptionalByEntityId(entityId));
    }

    public EntityMetaData identityProviderByEntityId(String entityId) {
        return this.nonEmptyOptionalToEntityMetaData(entityId, this.identityProviderOptionalByEntityId(entityId));
    }

    public void enrichPdPPolicyDefinition(PdpPolicyDefinition pd) {
        List entityIds = pd.getIdentityProviderIds();
        List metaDataList = this.identityProviders().stream().filter(idp -> entityIds.contains(idp.getEntityId())).collect(Collectors.toList());
        pd.setIdentityProviderNames(metaDataList.stream().map(EntityMetaData::getNameEn).collect(Collectors.toList()));
        pd.setIdentityProviderNamesNl(metaDataList.stream().map(EntityMetaData::getNameNl).collect(Collectors.toList()));
    }

    public void allowAll(boolean allowAll) {
        this.identityProviders().forEach(md -> this.doAllowAll(md, allowAll));
        this.serviceProviders().forEach(md -> this.doAllowAll(md, allowAll));
    }

    private void doAllowAll(EntityMetaData md, boolean allowAll) {
        try {
            ReflectionUtils.setField((Field)EntityMetaData.class.getDeclaredField("allowedAll"), (Object)md, (Object)allowAll);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

