/*
 * Decompiled with CFR 0.152.
 */
package pdp.manage;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import pdp.JsonMapper;
import pdp.access.PolicyIdpAccessUnknownIdentityProvidersException;
import pdp.domain.EntityMetaData;
import pdp.domain.PdpPolicyDefinition;

public interface Manage
extends JsonMapper {
    public static final Logger LOG = LoggerFactory.getLogger(Manage.class);

    public List<EntityMetaData> serviceProviders();

    public List<EntityMetaData> identityProviders();

    public Set<EntityMetaData> identityProvidersByAuthenticatingAuthority(String var1);

    public Set<EntityMetaData> serviceProvidersByInstitutionId(String var1);

    public Optional<EntityMetaData> serviceProviderOptionalByEntityId(String var1);

    public Optional<EntityMetaData> identityProviderOptionalByEntityId(String var1);

    public EntityMetaData serviceProviderByEntityId(String var1);

    public EntityMetaData identityProviderByEntityId(String var1);

    public void enrichPdPPolicyDefinition(PdpPolicyDefinition var1);

    default public List<EntityMetaData> parseEntities(Resource resource) {
        try {
            List list = (List)objectMapper.readValue(resource.getInputStream(), List.class);
            return list.stream().map(entry -> {
                Map data = (Map)entry.get("data");
                Map metaDataFields = (Map)data.get("metaDataFields");
                return new EntityMetaData((String)data.get("entityid"), (String)metaDataFields.get("coin:institution_id"), (String)metaDataFields.get("name:en"), (String)metaDataFields.get("name:nl"), this.getPolicyEnforcementDecisionRequired(metaDataFields), data.getOrDefault("allowedall", true).booleanValue(), new HashSet(data.getOrDefault("allowedEntities", Collections.emptyList())));
            }).sorted(Comparator.comparing(metaData -> metaData.getNameEn() != null ? metaData.getNameEn() : (metaData.getNameNl() != null ? metaData.getNameNl() : metaData.getEntityId()))).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    default public boolean getPolicyEnforcementDecisionRequired(Map<String, Object> entry) {
        Object policyEnforcementDecisionRequired = entry.get("coin:policy_enforcement_decision_required");
        if (policyEnforcementDecisionRequired != null) {
            if (policyEnforcementDecisionRequired instanceof Boolean) {
                return (Boolean)policyEnforcementDecisionRequired;
            }
            if (policyEnforcementDecisionRequired instanceof String) {
                return policyEnforcementDecisionRequired.equals("1");
            }
        }
        return false;
    }

    default public EntityMetaData nonEmptyOptionalToEntityMetaData(String entityId, Optional<EntityMetaData> entityMetaDataOptional) {
        if (!entityMetaDataOptional.isPresent()) {
            LOG.error(entityId + " is not a valid or known IdP / SP entityId");
            throw new PolicyIdpAccessUnknownIdentityProvidersException(entityId + " is not a valid or known IdP / SP entityId");
        }
        return entityMetaDataOptional.get();
    }
}

