/*
 * Decompiled with CFR 0.152.
 */
package pdp.policies;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import pdp.domain.EntityMetaData;
import pdp.domain.PdpPolicyDefinition;
import pdp.mail.MailBox;
import pdp.manage.Manage;
import pdp.repositories.PdpPolicyRepository;
import pdp.xacml.PdpPolicyDefinitionParser;

public class PolicyMissingServiceProviderValidator {
    private MailBox mailBox;
    private Manage manage;
    private PdpPolicyRepository pdpPolicyRepository;
    private final PdpPolicyDefinitionParser pdpPolicyDefinitionParser = new PdpPolicyDefinitionParser();

    public PolicyMissingServiceProviderValidator(MailBox mailBox, Manage manage, PdpPolicyRepository pdpPolicyRepository, boolean pdpCronJobResponsible) {
        this.mailBox = mailBox;
        this.manage = manage;
        this.pdpPolicyRepository = pdpPolicyRepository;
        if (pdpCronJobResponsible) {
            Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> this.validate(), 1L, 168L, TimeUnit.HOURS);
        }
    }

    public PdpPolicyDefinition addEntityMetaData(PdpPolicyDefinition pd) {
        Optional sp = this.manage.serviceProviderOptionalByEntityId(pd.getServiceProviderId());
        pd.setServiceProviderInvalidOrMissing(!sp.isPresent());
        if (sp.isPresent()) {
            pd.setServiceProviderName(((EntityMetaData)sp.get()).getNameEn());
            pd.setServiceProviderNameNl(((EntityMetaData)sp.get()).getNameNl());
            pd.setActivatedSr(((EntityMetaData)sp.get()).isPolicyEnforcementDecisionRequired());
        }
        this.manage.enrichPdPPolicyDefinition(pd);
        return pd;
    }

    public void validate() {
        List invalidPolicies = this.pdpPolicyRepository.findAll().stream().map(policy -> this.addEntityMetaData(this.pdpPolicyDefinitionParser.parse(policy))).filter(policy -> policy.isServiceProviderInvalidOrMissing()).filter(policy -> policy.isActive()).collect(Collectors.toList());
        if (!invalidPolicies.isEmpty()) {
            this.mailBox.sendInvalidPoliciesMail(invalidPolicies);
        }
    }
}

