/*
 * Decompiled with CFR 0.152.
 */
package pdp.web;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import pdp.access.FederatedUser;
import pdp.access.PolicyIdpAccessEnforcer;

@RestController
@RequestMapping(headers={"Content-Type=application/json"}, produces={"application/json"})
public class UserController {
    private static final Logger LOG = LoggerFactory.getLogger(UserController.class);
    @Autowired
    private ObjectMapper objectMapper;

    @RequestMapping(method={RequestMethod.GET}, value={"internal/users/me"})
    public FederatedUser user() {
        return (FederatedUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
    }

    @PostMapping(value={"internal/users/error"})
    public void error(@RequestBody Map<String, Object> payload) throws JsonProcessingException, UnknownHostException {
        payload.put("dateTime", new SimpleDateFormat("yyyyy-mm-dd hh:mm:ss").format(new Date()));
        payload.put("machine", InetAddress.getLocalHost().getHostName());
        payload.put("user", PolicyIdpAccessEnforcer.federatedUser());
        String msg = this.objectMapper.writeValueAsString(payload);
        LOG.error(msg, (Throwable)new IllegalArgumentException(msg));
    }
}

