/*
 * Decompiled with CFR 0.152.
 */
package pdp.manage;

import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import pdp.domain.EntityMetaData;
import pdp.domain.PdpPolicyDefinition;
import pdp.manage.Manage;

public class UrlResourceManage
implements Manage {
    private static final Logger LOG = LoggerFactory.getLogger(UrlResourceManage.class);
    private final String manageBaseUrl;
    private final RestTemplate restTemplate = new RestTemplate();
    private final HttpHeaders httpHeaders;
    private String requestedAttributes = "REQUESTED_ATTRIBUTES\":[\"metaDataFields.coin:institution_id\", \"metaDataFields.coin:policy_enforcement_decision_required\", \"allowedall\", \"allowedEntities\"]";
    private String body = "{\"" + this.requestedAttributes + "}";
    private String bodyForEntity = "{\"entityid\":\"@@entityid@@\", \"" + this.requestedAttributes + "}";
    private String bodyForEntityIdIn = "{\"entityid\":[@@entityids@@], \"" + this.requestedAttributes + "}";
    private String bodyForInstitutionId = "{\"metaDataFields.coin:institution_id\":\"@@institution_id@@\", \"" + this.requestedAttributes + "}";

    public UrlResourceManage(String username, String password, String manageBaseUrl) {
        String basicAuth = "Basic " + new String(Base64.getEncoder().encode((username + ":" + password).getBytes()));
        this.manageBaseUrl = manageBaseUrl;
        this.httpHeaders = new HttpHeaders();
        this.httpHeaders.add("Content-Type", "application/json");
        this.httpHeaders.add("Authorization", basicAuth);
        SimpleClientHttpRequestFactory requestFactory = (SimpleClientHttpRequestFactory)this.restTemplate.getRequestFactory();
        requestFactory.setConnectTimeout(10000);
    }

    private Resource getIdpResource(String body) {
        LOG.debug("Fetching IDP metadata entries from {} with body {}", (Object)this.manageBaseUrl, (Object)body);
        ResponseEntity responseEntity = this.restTemplate.exchange(this.manageBaseUrl + "/manage/api/internal/search/saml20_idp", HttpMethod.POST, new HttpEntity((Object)body, (MultiValueMap)this.httpHeaders), String.class, new Object[0]);
        return new ByteArrayResource(((String)responseEntity.getBody()).getBytes());
    }

    private Resource getSpResource(String body) {
        LOG.debug("Fetching SP metadata entries from {} with body {}", (Object)this.manageBaseUrl, (Object)body);
        ResponseEntity responseEntity = this.restTemplate.exchange(this.manageBaseUrl + "/manage/api/internal/search/saml20_sp", HttpMethod.POST, new HttpEntity((Object)body, (MultiValueMap)this.httpHeaders), String.class, new Object[0]);
        return new ByteArrayResource(((String)responseEntity.getBody()).getBytes());
    }

    public List<EntityMetaData> serviceProviders() {
        return this.parseEntities(this.getSpResource(this.body));
    }

    public List<EntityMetaData> identityProviders() {
        return this.parseEntities(this.getIdpResource(this.body));
    }

    public Set<EntityMetaData> identityProvidersByAuthenticatingAuthority(String authenticatingAuthority) {
        EntityMetaData idp = this.identityProviderByEntityId(authenticatingAuthority);
        String institutionId = idp.getInstitutionId();
        if (StringUtils.hasText((String)institutionId)) {
            String body = this.bodyForInstitutionId.replace("@@institution_id@@", institutionId);
            List entityMetaData = this.parseEntities(this.getIdpResource(body));
            return new HashSet<EntityMetaData>(entityMetaData);
        }
        return Collections.singleton(idp);
    }

    public Set<EntityMetaData> serviceProvidersByInstitutionId(String institutionId) {
        if (StringUtils.isEmpty((Object)institutionId)) {
            return Collections.emptySet();
        }
        return new HashSet<EntityMetaData>(this.parseEntities(this.getSpResource(this.bodyForInstitutionId.replace("@@institution_id@@", institutionId))));
    }

    public Optional<EntityMetaData> serviceProviderOptionalByEntityId(String entityId) {
        List entityMetaData = this.parseEntities(this.getSpResource(this.bodyForEntity.replace("@@entityid@@", entityId)));
        return entityMetaData.isEmpty() ? Optional.empty() : Optional.of(entityMetaData.get(0));
    }

    public Optional<EntityMetaData> identityProviderOptionalByEntityId(String entityId) {
        String replaced = this.bodyForEntity.replace("@@entityid@@", entityId);
        List entityMetaData = this.parseEntities(this.getIdpResource(replaced));
        return entityMetaData.isEmpty() ? Optional.empty() : Optional.of(entityMetaData.get(0));
    }

    public EntityMetaData serviceProviderByEntityId(String entityId) {
        return this.nonEmptyOptionalToEntityMetaData(entityId, this.serviceProviderOptionalByEntityId(entityId));
    }

    public EntityMetaData identityProviderByEntityId(String entityId) {
        return this.nonEmptyOptionalToEntityMetaData(entityId, this.identityProviderOptionalByEntityId(entityId));
    }

    public void enrichPdPPolicyDefinition(PdpPolicyDefinition pd) {
        List entityIds = pd.getIdentityProviderIds();
        if (CollectionUtils.isEmpty((Collection)entityIds) || entityIds.stream().allMatch(s -> StringUtils.isEmpty((Object)s))) {
            pd.setIdentityProviderNames(new ArrayList());
            pd.setIdentityProviderNamesNl(new ArrayList());
        } else {
            String queryValue = String.join((CharSequence)",", entityIds.stream().map(s -> "\"" + s + "\"").collect(Collectors.toList()));
            String replaced = this.bodyForEntityIdIn.replace("@@entityids@@", queryValue);
            List identityProviders = this.parseEntities(this.getIdpResource(replaced));
            pd.setIdentityProviderNames(identityProviders.stream().map(EntityMetaData::getNameEn).collect(Collectors.toList()));
            pd.setIdentityProviderNamesNl(identityProviders.stream().map(EntityMetaData::getNameNl).collect(Collectors.toList()));
        }
    }
}

