/*
 * Decompiled with CFR 0.152.
 */
package pdp.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.util.CollectionUtils;
import pdp.domain.CidrNotation;
import pdp.domain.PdpAttribute;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LoA {
    private String level;
    private boolean allAttributesMustMatch;
    @Valid
    private List<PdpAttribute> attributes = new ArrayList();
    @Valid
    private List<CidrNotation> cidrNotations = new ArrayList();

    @JsonIgnore
    public List<String> anyCidrNotations() {
        return CollectionUtils.isEmpty((Collection)this.cidrNotations) ? Collections.emptyList() : Arrays.asList("will-iterate-once");
    }

    @JsonIgnore
    public List<String> anyAttributes() {
        return CollectionUtils.isEmpty((Collection)this.attributes) ? Collections.emptyList() : Arrays.asList("will-iterate-once");
    }

    @JsonIgnore
    public boolean empty() {
        return CollectionUtils.isEmpty((Collection)this.cidrNotations) && CollectionUtils.isEmpty((Collection)this.attributes);
    }

    @JsonIgnore
    public Set<Map.Entry<String, List<PdpAttribute>>> allAttributesGrouped() {
        return this.attributes.stream().collect(Collectors.groupingBy(PdpAttribute::getName)).entrySet();
    }

    public LoA(String level, boolean allAttributesMustMatch, List<PdpAttribute> attributes, List<CidrNotation> cidrNotations) {
        this.level = level;
        this.allAttributesMustMatch = allAttributesMustMatch;
        this.attributes = attributes;
        this.cidrNotations = cidrNotations;
    }

    public LoA() {
    }

    public String getLevel() {
        return this.level;
    }

    public boolean isAllAttributesMustMatch() {
        return this.allAttributesMustMatch;
    }

    public List<PdpAttribute> getAttributes() {
        return this.attributes;
    }

    public List<CidrNotation> getCidrNotations() {
        return this.cidrNotations;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public void setAllAttributesMustMatch(boolean allAttributesMustMatch) {
        this.allAttributesMustMatch = allAttributesMustMatch;
    }

    public void setAttributes(List<PdpAttribute> attributes) {
        this.attributes = attributes;
    }

    public void setCidrNotations(List<CidrNotation> cidrNotations) {
        this.cidrNotations = cidrNotations;
    }
}

