/*
 * Decompiled with CFR 0.152.
 */
package pdp.access;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import pdp.JsonMapper;
import pdp.access.FederatedUser;
import pdp.access.PolicyAccess;
import pdp.access.PolicyIdpAccessEnforcer;
import pdp.access.PolicyIdpAccessMismatchIdentityProvidersException;
import pdp.access.PolicyIdpAccessMismatchServiceProviderException;
import pdp.access.PolicyIdpAccessMissingFederatedUserException;
import pdp.access.PolicyIdpAccessOriginatingIdentityProviderException;
import pdp.domain.EntityMetaData;
import pdp.domain.JsonPolicyRequest;
import pdp.domain.PdpPolicy;
import pdp.domain.PdpPolicyDefinition;
import pdp.domain.PdpPolicyViolation;
import pdp.util.StreamUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class PolicyIdpAccessEnforcer
implements JsonMapper {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyIdpAccessEnforcer.class);

    public void actionAllowed(PdpPolicy pdpPolicy, PolicyAccess policyAccess, String serviceProviderId, List<String> identityProviderIds) {
        this.doActionAllowed(pdpPolicy, policyAccess, serviceProviderId, identityProviderIds, true);
    }

    public boolean actionAllowedIndicator(PdpPolicy pdpPolicy, PolicyAccess policyAccess, String serviceProviderId, List<String> identityProviderIds) {
        return this.doActionAllowed(pdpPolicy, policyAccess, serviceProviderId, identityProviderIds, false);
    }

    private boolean doActionAllowed(PdpPolicy pdpPolicy, PolicyAccess policyAccess, String serviceProviderId, List<String> identityProviderIds, boolean throwException) {
        Set idpsOfUserEntityIds;
        String userIdentifier;
        String authenticatingAuthorityUser;
        block16: {
            block15: {
                FederatedUser user = PolicyIdpAccessEnforcer.federatedUser();
                if (!user.isPolicyIdpAccessEnforcementRequired()) {
                    return true;
                }
                Assert.notNull((Object)policyAccess, (String)"PolicyAccess must not be null");
                if (policyAccess.equals((Object)PolicyAccess.VIOLATIONS)) {
                    return true;
                }
                Assert.hasText((String)serviceProviderId, (String)"ServiceProvider ID must have text");
                authenticatingAuthorityUser = user.getAuthenticatingAuthority();
                userIdentifier = user.getIdentifier();
                idpsOfUserEntityIds = this.getEntityIds(user.getIdpEntities());
                Set spsOfUserEntityIds = this.getEntityIds(user.getSpEntities());
                if (!CollectionUtils.isEmpty(identityProviderIds)) break block15;
                switch (1.$SwitchMap$pdp$access$PolicyAccess[policyAccess.ordinal()]) {
                    case 1: {
                        if (!this.idpIsAllowed(user, idpsOfUserEntityIds, serviceProviderId)) {
                            if (throwException) {
                                throw new PolicyIdpAccessMismatchServiceProviderException(String.format("Policy for target SP '%s' requested by '%s', but this SP is not allowed access by users from IdP '%s'", serviceProviderId, userIdentifier, authenticatingAuthorityUser));
                            }
                            return false;
                        }
                        break block16;
                    }
                    case 2: {
                        if (!spsOfUserEntityIds.contains(serviceProviderId)) {
                            if (throwException) {
                                throw new PolicyIdpAccessMismatchServiceProviderException(String.format("Policy for target SP '%s' requested by '%s', but this SP is not linked to users IdP '%s'", serviceProviderId, userIdentifier, authenticatingAuthorityUser));
                            }
                            return false;
                        }
                        break block16;
                    }
                    default: {
                        throw new IllegalArgumentException("Not handled PolicyAccess " + policyAccess);
                    }
                }
            }
            if (!idpsOfUserEntityIds.containsAll(identityProviderIds)) {
                if (throwException) {
                    throw new PolicyIdpAccessMismatchIdentityProvidersException(String.format("Policy for target IdPs '%s' requested by '%s', but not all are linked to users IdP '%s", identityProviderIds, userIdentifier, authenticatingAuthorityUser));
                }
                return false;
            }
        }
        if (policyAccess.equals((Object)PolicyAccess.READ)) {
            return true;
        }
        String authenticatingAuthorityPolicy = pdpPolicy.getAuthenticatingAuthority();
        if (!authenticatingAuthorityPolicy.equals(authenticatingAuthorityUser) && !idpsOfUserEntityIds.contains(authenticatingAuthorityPolicy)) {
            if (throwException) {
                throw new PolicyIdpAccessOriginatingIdentityProviderException(String.format("Policy created by admin '%s' of IdP '%s' can not be updated / deleted by admin '%s' of IdP '%s'", pdpPolicy.getUserIdentifier(), authenticatingAuthorityPolicy, userIdentifier, authenticatingAuthorityUser));
            }
            return false;
        }
        return true;
    }

    public Iterable<PdpPolicyViolation> filterViolations(Iterable<PdpPolicyViolation> violations) {
        FederatedUser user = PolicyIdpAccessEnforcer.federatedUser();
        if (!user.isPolicyIdpAccessEnforcementRequired()) {
            return violations;
        }
        Set idpsOfUserEntityIds = this.getEntityIds(user.getIdpEntities());
        return StreamSupport.stream(violations.spliterator(), false).filter(violation -> this.maySeeViolation(violation, idpsOfUserEntityIds)).collect(Collectors.toList());
    }

    private boolean maySeeViolation(PdpPolicyViolation violation, Set<String> idpsOfUserEntityIds) {
        JsonPolicyRequest jsonPolicyRequest;
        try {
            jsonPolicyRequest = (JsonPolicyRequest)objectMapper.readValue(violation.getJsonRequest(), JsonPolicyRequest.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String idp = this.getEntityAttributeValue(jsonPolicyRequest, "IDPentityID");
        return idpsOfUserEntityIds.contains(idp);
    }

    private String getEntityAttributeValue(JsonPolicyRequest jsonPolicyRequest, String attributeName) {
        return ((JsonPolicyRequest.Attribute)jsonPolicyRequest.request.resource.attributes.stream().filter((Predicate<JsonPolicyRequest.Attribute>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getEntityAttributeValue$1(java.lang.String pdp.domain.JsonPolicyRequest$Attribute ), (Lpdp/domain/JsonPolicyRequest$Attribute;)Z)((String)attributeName)).collect(StreamUtils.singletonCollector())).value;
    }

    public List<PdpPolicyDefinition> filterPdpPolicies(List<PdpPolicyDefinition> policies) {
        FederatedUser user = PolicyIdpAccessEnforcer.federatedUser();
        if (!user.isPolicyIdpAccessEnforcementRequired()) {
            return policies;
        }
        Set idpsOfUserEntityIds = this.getEntityIds(user.getIdpEntities());
        Set spsOfUserEntityIds = this.getEntityIds(user.getSpEntities());
        return policies.stream().filter(policy -> this.maySeePolicy(policy, user, idpsOfUserEntityIds, spsOfUserEntityIds)).collect(Collectors.toList());
    }

    private boolean maySeePolicy(PdpPolicyDefinition pdpPolicyDefinition, FederatedUser user, Set<String> idpsOfUserEntityIds, Set<String> spsOfUserEntityIds) {
        List identityProviderIds = pdpPolicyDefinition.getIdentityProviderIds();
        if (CollectionUtils.isEmpty((Collection)identityProviderIds) && (this.idpIsAllowed(user, idpsOfUserEntityIds, pdpPolicyDefinition.getServiceProviderId()) || spsOfUserEntityIds.contains(pdpPolicyDefinition.getServiceProviderId()))) {
            return true;
        }
        return identityProviderIds.stream().anyMatch(idp -> idpsOfUserEntityIds.contains(idp));
    }

    private boolean idpIsAllowed(FederatedUser user, Set<String> idpsOfUserEntityIds, String serviceProviderId) {
        boolean isAllowedFromIdp = user.getIdpEntities().stream().anyMatch(idp -> idp.isAllowedFrom(new String[]{serviceProviderId}));
        return isAllowedFromIdp;
    }

    public List<EntityMetaData> filterIdentityProviders(List<EntityMetaData> identityProviders) {
        FederatedUser user = PolicyIdpAccessEnforcer.federatedUser();
        if (!user.isPolicyIdpAccessEnforcementRequired()) {
            return identityProviders;
        }
        Set idpsOfUserEntityIds = this.getEntityIds(user.getIdpEntities());
        return identityProviders.stream().filter(idp -> idpsOfUserEntityIds.contains(idp.getEntityId())).collect(Collectors.toList());
    }

    private Set<String> getEntityIds(Set<EntityMetaData> entities) {
        return entities.stream().map(EntityMetaData::getEntityId).collect(Collectors.toSet());
    }

    public static FederatedUser federatedUser() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (!FederatedUser.class.isAssignableFrom(principal.getClass())) {
            LOG.warn("Could not find federated user, but {}", principal);
            throw new PolicyIdpAccessMissingFederatedUserException("Could not find authenticated federated user");
        }
        return (FederatedUser)principal;
    }

    public String username() {
        return PolicyIdpAccessEnforcer.federatedUser().getIdentifier();
    }

    public String authenticatingAuthority() {
        return PolicyIdpAccessEnforcer.federatedUser().getAuthenticatingAuthority();
    }

    public String userDisplayName() {
        return PolicyIdpAccessEnforcer.federatedUser().getDisplayName();
    }

    public boolean isPolicyIdpAccessEnforcementRequired() {
        return PolicyIdpAccessEnforcer.federatedUser().isPolicyIdpAccessEnforcementRequired();
    }

    private static /* synthetic */ boolean lambda$getEntityAttributeValue$1(String attributeName, JsonPolicyRequest.Attribute attr) {
        return attr.attributeId.equals(attributeName);
    }
}

