/*
 * Decompiled with CFR 0.152.
 */
package pdp;

import java.io.IOException;
import org.apache.openaz.xacml.util.FactoryException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.autoconfigure.ManagementWebSecurityAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.MetricFilterAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.TraceWebFilterAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.security.SecurityAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import pdp.policies.PolicyLoader;
import pdp.repositories.PdpPolicyRepository;
import pdp.sab.SabClient;
import pdp.stats.StatsContextHolder;
import pdp.teams.VootClient;
import pdp.xacml.PDPEngineHolder;

@SpringBootApplication(exclude={ManagementWebSecurityAutoConfiguration.class, SecurityAutoConfiguration.class, TraceWebFilterAutoConfiguration.class, MetricFilterAutoConfiguration.class})
public class PdpApplication {
    @Autowired
    private ResourceLoader resourceLoader;

    public static void main(String[] args) {
        SpringApplication.run(PdpApplication.class, (String[])args);
    }

    @Bean
    public StatsContextHolder statsContextHolder() {
        return new StatsContextHolder("decide/policy");
    }

    @Bean
    public PDPEngineHolder pdpEngine(@Value(value="${xacml.properties.path}") String xacmlPropertiesFileLocation, PdpPolicyRepository pdpPolicyRepository, VootClient vootClient, SabClient sabClient, PolicyLoader policyLoader) throws IOException, FactoryException {
        Resource resource = this.resourceLoader.getResource(xacmlPropertiesFileLocation);
        String absolutePath = resource.getFile().getAbsolutePath();
        System.setProperty("xacml.properties", absolutePath);
        policyLoader.loadPolicies();
        return new PDPEngineHolder(pdpPolicyRepository, vootClient, sabClient);
    }
}

