/*
 * Decompiled with CFR 0.152.
 */
package pdp.web;

import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import pdp.domain.Validation;
import pdp.ip.IPInfo;
import pdp.validations.IPAddressValidator;
import pdp.validations.Validator;
import pdp.web.IPAddressProvider;

@RestController
public class ValidationController
implements IPAddressProvider {
    private final Map<String, Validator> validators = Arrays.asList(new IPAddressValidator()).stream().collect(Collectors.toMap(Validator::getType, Function.identity()));

    @PostMapping(value={"/internal/validate", "/protected/validate"})
    public boolean validation(@Validated @RequestBody Validation validation) {
        return !this.validators.computeIfAbsent(validation.getType(), key -> {
            throw new IllegalArgumentException(String.format("No validation defined for %s", key));
        }).validate(validation.getValue()).isPresent();
    }

    @GetMapping(value={"/internal/ipinfo", "/protected/ipinfo"})
    public IPInfo ipInfo(@RequestParam String ipAddress, @RequestParam(required=false) Integer networkPrefix) throws UnknownHostException {
        if (!this.validation(new Validation("ip", ipAddress))) {
            return new IPInfo();
        }
        return this.getIpInfo(ipAddress, networkPrefix);
    }
}

