/*
 * Decompiled with CFR 0.152.
 */
package pdp.policies;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import pdp.domain.EntityMetaData;
import pdp.domain.PdpPolicyDefinition;
import pdp.mail.MailBox;
import pdp.manage.Manage;
import pdp.repositories.PdpPolicyRepository;
import pdp.xacml.PdpPolicyDefinitionParser;

public class PolicyMissingServiceProviderValidator {
    private MailBox mailBox;
    private Manage manage;
    private PdpPolicyRepository pdpPolicyRepository;
    private final PdpPolicyDefinitionParser pdpPolicyDefinitionParser = new PdpPolicyDefinitionParser();

    public PolicyMissingServiceProviderValidator(MailBox mailBox, Manage manage, PdpPolicyRepository pdpPolicyRepository, boolean pdpCronJobResponsible) {
        this.mailBox = mailBox;
        this.manage = manage;
        this.pdpPolicyRepository = pdpPolicyRepository;
        if (pdpCronJobResponsible) {
            Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> this.validate(), 1L, 168L, TimeUnit.HOURS);
        }
    }

    public List<PdpPolicyDefinition> addEntityMetaData(List<PdpPolicyDefinition> pdpPolicyDefinitions) {
        Set idpEntitiesIds = pdpPolicyDefinitions.stream().map(PdpPolicyDefinition::getIdentityProviderIds).flatMap(Collection::stream).collect(Collectors.toSet());
        idpEntitiesIds.addAll(pdpPolicyDefinitions.stream().map(PdpPolicyDefinition::getAuthenticatingAuthorityName).collect(Collectors.toSet()));
        Map identityProviders = this.manage.identityProvidersByEntityIds(idpEntitiesIds);
        Set spEntitiesIds = pdpPolicyDefinitions.stream().map(PdpPolicyDefinition::getServiceProviderId).collect(Collectors.toSet());
        Map serviceProviders = this.manage.serviceProvidersByEntityIds(spEntitiesIds);
        pdpPolicyDefinitions.forEach(pd -> {
            EntityMetaData sp;
            EntityMetaData emd = (EntityMetaData)identityProviders.get(pd.getAuthenticatingAuthorityName());
            if (emd != null) {
                pd.setAuthenticatingAuthorityName(emd.getNameEn());
            }
            pd.setServiceProviderInvalidOrMissing((sp = (EntityMetaData)serviceProviders.get(pd.getServiceProviderId())) == null);
            if (sp != null) {
                pd.setServiceProviderName(sp.getNameEn());
                pd.setServiceProviderNameNl(sp.getNameNl());
                pd.setActivatedSr(sp.isPolicyEnforcementDecisionRequired());
            }
            List entityIds = pd.getIdentityProviderIds();
            pd.setIdentityProviderNames(identityProviders.values().stream().filter(idp -> entityIds.contains(idp.getEntityId())).map(idp -> idp.getNameEn()).collect(Collectors.toList()));
            pd.setIdentityProviderNamesNl(identityProviders.values().stream().filter(idp -> entityIds.contains(idp.getEntityId())).map(idp -> idp.getNameNl()).collect(Collectors.toList()));
        });
        return pdpPolicyDefinitions;
    }

    public void validate() {
        List pdpPolicyDefinitions = this.pdpPolicyRepository.findAll().stream().map(policy -> this.pdpPolicyDefinitionParser.parse(policy)).collect(Collectors.toList());
        List invalidPolicies = this.addEntityMetaData(pdpPolicyDefinitions).stream().filter(policy -> policy.isServiceProviderInvalidOrMissing()).filter(policy -> policy.isActive()).collect(Collectors.toList());
        if (!invalidPolicies.isEmpty()) {
            this.mailBox.sendInvalidPoliciesMail(invalidPolicies);
        }
    }
}

