/*
 * Decompiled with CFR 0.152.
 */
package pdp.sab;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;
import pdp.sab.PreemptiveAuthenticationHttpComponentsClientHttpRequestFactory;
import pdp.sab.SabResponseParser;

public class SabClient {
    private static final Logger LOG = LoggerFactory.getLogger(SabClient.class);
    private static final DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTimeNoMillis().withZone(DateTimeZone.UTC);
    private final String sabUserName;
    private final String sabPassword;
    private final String sabEndpoint;
    private final RestTemplate restTemplate;
    private final String template;
    private final SabResponseParser parser = new SabResponseParser();

    public SabClient(String sabUserName, String sabPassword, String sabEndpoint) {
        this.sabUserName = sabUserName;
        this.sabPassword = sabPassword;
        this.sabEndpoint = sabEndpoint;
        try {
            this.template = IOUtils.toString((InputStream)new ClassPathResource("sab/request.xml").getInputStream(), (Charset)Charset.defaultCharset());
            this.restTemplate = new RestTemplate(Arrays.asList(new ByteArrayHttpMessageConverter(), new StringHttpMessageConverter()));
            this.restTemplate.setRequestFactory(this.getRequestFactory());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> roles(String userId) {
        String request = this.request(userId);
        ResponseEntity response = this.restTemplate.exchange(this.sabEndpoint, HttpMethod.POST, new HttpEntity((Object)request), byte[].class, new Object[0]);
        try {
            List roles = this.parser.parse((InputStream)new ByteArrayInputStream((byte[])response.getBody()));
            LOG.debug("Retrieved SAB roles with request: {} and response: {}", (Object)request, (Object)response);
            return roles;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String request(String userId) {
        String issueInstant = dateTimeFormatter.print(System.currentTimeMillis());
        return MessageFormat.format(this.template, UUID.randomUUID().toString(), issueInstant, userId);
    }

    private ClientHttpRequestFactory getRequestFactory() throws MalformedURLException {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().evictExpiredConnections().evictIdleConnections(10L, TimeUnit.SECONDS);
        BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
        basicCredentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.sabUserName, this.sabPassword));
        httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        int timeOut = 10000;
        httpClientBuilder.setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(timeOut).setConnectTimeout(timeOut).setSocketTimeout(timeOut).build());
        CloseableHttpClient httpClient = httpClientBuilder.build();
        return new PreemptiveAuthenticationHttpComponentsClientHttpRequestFactory((HttpClient)httpClient, this.sabEndpoint);
    }
}

