/*
 * Decompiled with CFR 0.152.
 */
package pdp.negate;

import java.util.List;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.XACML;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.policy.FunctionDefinition;
import org.apache.openaz.xacml.std.IdentifierImpl;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.DataTypeBoolean;

public class NegateFunctionDefinition
implements FunctionDefinition {
    private static final IdentifierImpl IDENTIFIER = new IdentifierImpl("urn:surfnet:cbac:custom:function:3.0:negation");

    public Identifier getId() {
        return IDENTIFIER;
    }

    public Identifier getDataTypeId() {
        return XACML.ID_DATATYPE_BOOLEAN;
    }

    public boolean returnsBag() {
        return false;
    }

    public ExpressionResult evaluate(EvaluationContext evaluationContext, List<FunctionArgument> arguments) {
        if (arguments.size() != 2) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR));
        }
        String policyValue = (String)arguments.get(0).getValue().getValue();
        AttributeValue value = arguments.get(1).getValue();
        String actualValue = value != null ? (String)value.getValue() : "";
        AttributeValue booleanAttributeValue = policyValue.equalsIgnoreCase(actualValue) ? DataTypeBoolean.AV_FALSE : DataTypeBoolean.AV_TRUE;
        return ExpressionResult.newSingle((AttributeValue)booleanAttributeValue);
    }
}

