/*
 * Decompiled with CFR 0.152.
 */
package pdp.shibboleth;

import java.io.UnsupportedEncodingException;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.util.StringUtils;
import pdp.access.FederatedUserBuilder;
import pdp.access.RunAsFederatedUser;
import pdp.manage.Manage;

public class ShibbolethPreAuthenticatedProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    private final FederatedUserBuilder federatedUserBuilder;

    public ShibbolethPreAuthenticatedProcessingFilter(AuthenticationManager authenticationManager, Manage manage) {
        this.setAuthenticationManager(authenticationManager);
        this.federatedUserBuilder = new FederatedUserBuilder(manage);
        this.setCheckForPrincipalChanges(true);
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        Optional federatedUser = this.federatedUserBuilder.shibUser(request);
        if (!federatedUser.isPresent()) {
            return null;
        }
        if (StringUtils.hasText((String)this.getHeader("X-IMPERSONATE", request))) {
            federatedUser = this.federatedUserBuilder.basicAuthUser(request, FederatedUserBuilder.apiAuthorities);
        }
        return federatedUser.isPresent() ? federatedUser.get() : null;
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return "N/A";
    }

    protected boolean principalChanged(HttpServletRequest request, Authentication currentAuthentication) {
        return StringUtils.hasText((String)this.getHeader("X-IMPERSONATE", request)) || currentAuthentication.getPrincipal() instanceof RunAsFederatedUser;
    }

    private String getHeader(String name, HttpServletRequest request) {
        String header = request.getHeader(name);
        try {
            return StringUtils.hasText((String)header) ? new String(header.getBytes("ISO8859-1"), "UTF-8") : header;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

