/*
 * Decompiled with CFR 0.152.
 */
package pdp.xacml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.openaz.xacml.api.Decision;
import org.apache.openaz.xacml.pdp.policy.AdviceExpression;
import org.apache.openaz.xacml.pdp.policy.AttributeAssignmentExpression;
import org.apache.openaz.xacml.pdp.policy.Condition;
import org.apache.openaz.xacml.pdp.policy.Expression;
import org.apache.openaz.xacml.pdp.policy.Match;
import org.apache.openaz.xacml.pdp.policy.ObligationExpression;
import org.apache.openaz.xacml.pdp.policy.Policy;
import org.apache.openaz.xacml.pdp.policy.Rule;
import org.apache.openaz.xacml.pdp.policy.dom.DOMApply;
import org.apache.openaz.xacml.pdp.policy.dom.DOMAttributeDesignator;
import org.apache.openaz.xacml.pdp.policy.dom.DOMPolicyDef;
import org.apache.openaz.xacml.pdp.policy.expressions.AttributeDesignator;
import org.apache.openaz.xacml.pdp.policy.expressions.AttributeValueExpression;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import pdp.domain.CidrNotation;
import pdp.domain.LoA;
import pdp.domain.PdpAttribute;
import pdp.domain.PdpPolicy;
import pdp.domain.PdpPolicyDefinition;
import pdp.util.StreamUtils;
import pdp.web.IPAddressProvider;
import pdp.xacml.PdpParseException;

public class PdpPolicyDefinitionParser
implements IPAddressProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PdpPolicyDefinitionParser.class);
    public static final String SP_ENTITY_ID = "SPentityID";
    public static final String IDP_ENTITY_ID = "IDPentityID";
    public static final String NAME_ID = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
    public static final String IP_FUNCTION = "urn:surfnet:cbac:custom:function:3.0:ip:range";
    public static final String NEGATE_FUNCTION = "urn:surfnet:cbac:custom:function:3.0:negation";
    private static final String CLIENT_ID = "ClientID";

    public PdpPolicyDefinition parse(PdpPolicy pdpPolicy) {
        PdpPolicyDefinition definition = new PdpPolicyDefinition();
        String policyXml = pdpPolicy.getPolicyXml();
        Policy policy = this.parsePolicy(policyXml);
        definition.setId(pdpPolicy.getId());
        definition.setName(pdpPolicy.getName());
        definition.setDescription(policy.getDescription());
        definition.setCreated(pdpPolicy.getCreated());
        definition.setUserDisplayName(pdpPolicy.getUserDisplayName());
        definition.setRevisionNbr(pdpPolicy.getRevisionNbr());
        definition.setActive(pdpPolicy.isActive());
        definition.setType(pdpPolicy.getType());
        definition.setAuthenticatingAuthorityName(pdpPolicy.getAuthenticatingAuthority());
        this.parseTargets(policyXml, definition, policy);
        List rules = StreamUtils.iteratorToList((Iterator)policy.getRules());
        if (pdpPolicy.getType().equals("step")) {
            definition.setDenyRule(false);
            List loas = rules.stream().filter(rule -> rule.getObligationExpressions().hasNext()).map(arg_0 -> this.parseStepRule(arg_0)).collect(Collectors.toList());
            definition.setLoas(loas);
            definition.sortLoas();
        } else {
            definition.setDenyRule(!this.isPermitRule(policyXml, rules));
            this.parsePermit(policyXml, definition, rules);
            this.parseDeny(policyXml, definition, rules);
            Collections.sort(definition.getAttributes(), (a1, a2) -> a1.getName().compareTo(a2.getName()));
        }
        return definition;
    }

    private LoA parseStepRule(Rule rule) {
        LoA loa = new LoA();
        AttributeValueExpression attributeValueExpression = (AttributeValueExpression)AttributeValueExpression.class.cast(((AttributeAssignmentExpression)((ObligationExpression)rule.getObligationExpressions().next()).getAttributeAssignmentExpressions().next()).getExpression());
        String level = (String)attributeValueExpression.getAttributeValue().getValue();
        loa.setLevel(level);
        Condition condition = rule.getCondition();
        if (condition != null) {
            DOMApply domApply = (DOMApply)DOMApply.class.cast(condition.getExpression());
            boolean allAttributesMustMatch = domApply.getFunctionId().getUri().toString().endsWith("function:and");
            loa.setAllAttributesMustMatch(allAttributesMustMatch);
            this.parseArguments(loa, domApply.getArguments());
        }
        return loa;
    }

    private LoA parseArguments(LoA loA, Iterator<Expression> iterator) {
        List expressions = StreamUtils.iteratorToList(iterator);
        expressions.forEach(expression -> {
            if (expression instanceof DOMApply) {
                this.parseDomApply(loA, (DOMApply)DOMApply.class.cast(expression));
            }
        });
        return loA;
    }

    private LoA parseDomApply(LoA loA, DOMApply domApply) {
        String functionID = domApply.getFunctionId().getUri().toString();
        if (functionID.endsWith("function:not")) {
            loA.setNegateCidrNotation(true);
            return this.parseArguments(loA, domApply.getArguments());
        }
        if (functionID.equals(IP_FUNCTION)) {
            loA.getCidrNotations().add(this.parseCidrNotation(domApply));
            return loA;
        }
        if (functionID.endsWith("function:string-is-in") || functionID.equals(NEGATE_FUNCTION)) {
            this.addArgumentToLoa(loA, domApply, functionID.equals(NEGATE_FUNCTION));
            return loA;
        }
        return this.parseArguments(loA, domApply.getArguments());
    }

    private void addArgumentToLoa(LoA loA, DOMApply domApply, boolean negated) {
        AttributeValueExpression attributeValueExpression = (AttributeValueExpression)this.castArgument(AttributeValueExpression.class, domApply);
        String value = (String)attributeValueExpression.getAttributeValue().getValue();
        DOMAttributeDesignator attributeDesignator = (DOMAttributeDesignator)this.castArgument(DOMAttributeDesignator.class, domApply);
        String name = attributeDesignator.getAttributeId().getUri().toString();
        PdpAttribute pdpAttribute = new PdpAttribute(name, value);
        pdpAttribute.setNegated(negated);
        loA.getAttributes().add(pdpAttribute);
    }

    private <T> T castArgument(Class<T> clazz, DOMApply domApply) {
        return clazz.cast(StreamUtils.iteratorToList((Iterator)domApply.getArguments()).stream().filter(expression -> clazz.isAssignableFrom(expression.getClass())).findFirst().get());
    }

    private CidrNotation parseCidrNotation(DOMApply ipRange) {
        String functionId = ipRange.getFunctionId().getUri().toString();
        if (!functionId.equals(IP_FUNCTION)) {
            throw new IllegalArgumentException("Expected IP_FUNCTION, but got " + functionId);
        }
        List arguments = StreamUtils.iteratorToList((Iterator)ipRange.getArguments());
        Expression cidrNotationArgument = arguments.stream().filter(argument -> argument instanceof AttributeValueExpression).findFirst().get();
        String cidrNotation = (String)((AttributeValueExpression)AttributeValueExpression.class.cast(cidrNotationArgument)).getAttributeValue().getValue();
        String[] splitted = cidrNotation.split("/");
        return new CidrNotation(splitted[0], Integer.parseInt(splitted[1]), this.getIpInfo(splitted[0], Integer.valueOf(Integer.parseInt(splitted[1]))));
    }

    private void parseDeny(String policyXml, PdpPolicyDefinition definition, List<Rule> rules) {
        Rule denyRule = this.getRule(rules, Decision.DENY);
        this.parseAdviceExpression(definition, denyRule);
        if (!definition.isDenyRule()) {
            return;
        }
        this.parseAttributes(definition, denyRule, Decision.DENY);
    }

    private void parsePermit(String policyXml, PdpPolicyDefinition definition, List<Rule> rules) {
        if (definition.isDenyRule()) {
            return;
        }
        Rule permitRule = this.getRule(rules, Decision.PERMIT);
        this.parseAttributes(definition, permitRule, Decision.PERMIT);
    }

    private boolean isPermitRule(String policyXml, List<Rule> rules) {
        Rule rule = this.getRule(rules, Decision.PERMIT);
        return rule.getTarget().getAnyOfs() != null;
    }

    private Rule getRule(List<Rule> rules, Decision decision) {
        return (Rule)rules.stream().filter(r -> r.getRuleEffect().getDecision().equals((Object)decision)).collect(StreamUtils.singletonCollector());
    }

    private void parseAttributes(PdpPolicyDefinition definition, Rule rule, Decision decision) {
        List anyOfs = StreamUtils.iteratorToList((Iterator)rule.getTarget().getAnyOfs());
        if (anyOfs.size() > 1) {
            definition.setAllAttributesMustMatch(true);
        }
        List allOfs = anyOfs.stream().map(anyOf -> StreamUtils.iteratorToList((Iterator)anyOf.getAllOfs())).flatMap(allOf -> allOf.stream()).collect(Collectors.toList());
        List matches = allOfs.stream().map(allOf -> StreamUtils.iteratorToList((Iterator)allOf.getMatches())).flatMap(m -> m.stream()).collect(Collectors.toList());
        List pdpAttributes = matches.stream().map(match -> {
            String attributeName = ((AttributeDesignator)match.getAttributeRetrievalBase()).getAttributeId().getUri().toString();
            String attributeValue = (String)match.getAttributeValue().getValue();
            return new PdpAttribute(attributeName, attributeValue);
        }).collect(Collectors.toList());
        definition.setAttributes(pdpAttributes);
    }

    private void parseTargets(String policyXml, PdpPolicyDefinition definition, Policy policy) {
        List targetAnyOfs = StreamUtils.iteratorToList((Iterator)policy.getTarget().getAnyOfs());
        targetAnyOfs.forEach(anyOf -> {
            List idpEntityIDs;
            List targetAllOfs = StreamUtils.iteratorToList((Iterator)anyOf.getAllOfs());
            List targetMatches = targetAllOfs.stream().map(allOf -> StreamUtils.iteratorToList((Iterator)allOf.getMatches())).flatMap(Collection::stream).collect(Collectors.toList());
            List spEntityIDs = targetMatches.stream().filter(match -> ((AttributeDesignator)match.getAttributeRetrievalBase()).getAttributeId().getUri().toString().equalsIgnoreCase(SP_ENTITY_ID)).map(match -> (String)match.getAttributeValue().getValue()).collect(Collectors.toList());
            if (!spEntityIDs.isEmpty()) {
                definition.setServiceProviderIds(spEntityIDs);
            }
            if (!(idpEntityIDs = targetMatches.stream().filter(match -> ((AttributeDesignator)match.getAttributeRetrievalBase()).getAttributeId().getUri().toString().equalsIgnoreCase(IDP_ENTITY_ID)).map(match -> (String)match.getAttributeValue().getValue()).collect(Collectors.toList())).isEmpty()) {
                definition.setIdentityProviderIds(idpEntityIDs);
            }
            Optional<Match> clientIdOptional = targetMatches.stream().filter(match -> ((AttributeDesignator)match.getAttributeRetrievalBase()).getAttributeId().getUri().toString().equalsIgnoreCase(CLIENT_ID)).findFirst();
            clientIdOptional.ifPresent(clientId -> definition.setClientId((String)clientId.getAttributeValue().getValue()));
        });
        if (CollectionUtils.isEmpty((Collection)definition.getServiceProviderIds())) {
            throw new PdpParseException("SPentityIDs is required " + policyXml);
        }
    }

    private void parseAdviceExpression(PdpPolicyDefinition definition, Rule denyRule) {
        AdviceExpression adviceExpression = (AdviceExpression)StreamUtils.iteratorToList((Iterator)denyRule.getAdviceExpressions()).stream().collect(StreamUtils.singletonCollector());
        List attributeAssignmentExpressions = StreamUtils.iteratorToList((Iterator)adviceExpression.getAttributeAssignmentExpressions());
        String denyMesssageEN = this.extractDenyMessage(attributeAssignmentExpressions, "en");
        String denyMesssageNL = this.extractDenyMessage(attributeAssignmentExpressions, "nl");
        definition.setDenyAdvice(denyMesssageEN);
        definition.setDenyAdviceNl(denyMesssageNL);
    }

    private String extractDenyMessage(List<AttributeAssignmentExpression> attributeAssignmentExpressions, String language) {
        return (String)attributeAssignmentExpressions.stream().filter(ase -> ase.getAttributeId().getUri().toString().equals("DenyMessage:" + language)).map(ase -> (String)((AttributeValueExpression)ase.getExpression()).getAttributeValue().getValue()).collect(StreamUtils.singletonCollector());
    }

    public Policy parsePolicy(String policyXml) {
        String cleanedXml = policyXml.trim().replaceAll("\n", "").replaceAll(" +", " ");
        try {
            return (Policy)DOMPolicyDef.load((InputStream)new ByteArrayInputStream(cleanedXml.getBytes()));
        }
        catch (DOMStructureException e) {
            LOG.warn("Failed to parse policyXml", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

