/*
 * Decompiled with CFR 0.152.
 */
package pdp.domain;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import pdp.domain.PdpPolicy;
import pdp.xacml.PolicyTemplateEngine;

@Entity(name="pdp_migrated_policies")
public class PdpMigratedPolicy {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    private String policyId;
    @Column
    private String policyXml;
    @Column
    private String name;
    @Column
    private String authenticatingAuthority;
    @Column
    private String userIdentifier;
    @Column
    private String userDisplayName;
    @Column
    private String type;
    @Column(nullable=false, name="ts")
    private Date created;

    public PdpMigratedPolicy(PdpPolicy pdpPolicy) {
        this(pdpPolicy.getPolicyXml(), pdpPolicy.getName(), pdpPolicy.getUserIdentifier(), pdpPolicy.getAuthenticatingAuthority(), pdpPolicy.getUserDisplayName(), pdpPolicy.getType());
    }

    public PdpMigratedPolicy(String policyXml, String name, String userIdentifier, String authenticatingAuthority, String userDisplayName, String type) {
        this.policyXml = policyXml;
        this.name = name;
        this.userIdentifier = userIdentifier;
        this.userDisplayName = userDisplayName;
        this.authenticatingAuthority = authenticatingAuthority;
        this.policyId = PolicyTemplateEngine.getPolicyId((String)name);
        this.type = type;
        this.created = new Date();
    }

    public Long getId() {
        return this.id;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public String getPolicyXml() {
        return this.policyXml;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthenticatingAuthority() {
        return this.authenticatingAuthority;
    }

    public String getUserIdentifier() {
        return this.userIdentifier;
    }

    public String getUserDisplayName() {
        return this.userDisplayName;
    }

    public String getType() {
        return this.type;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    public void setPolicyXml(String policyXml) {
        this.policyXml = policyXml;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAuthenticatingAuthority(String authenticatingAuthority) {
        this.authenticatingAuthority = authenticatingAuthority;
    }

    public void setUserIdentifier(String userIdentifier) {
        this.userIdentifier = userIdentifier;
    }

    public void setUserDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public PdpMigratedPolicy() {
    }
}

