/*
 * Decompiled with CFR 0.152.
 */
package pdp.domain;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;
import org.springframework.util.StringUtils;

public class EntityMetaData
implements Serializable {
    private final String entityId;
    private final String institutionId;
    private final String nameEn;
    private final String nameNl;
    private final String organisationNameEn;
    private final String organisationNameNl;
    private final boolean policyEnforcementDecisionRequired;
    private final boolean allowedAll;
    private final Set<String> allowedEntityIds;

    public EntityMetaData(String entityId, String institutionId, String nameEn, String nameNl, String organisationNameEn, String organisationNameNl, boolean policyEnforcementDecisionRequired, boolean allowedAll, Set<String> allowedEntityIds) {
        this.entityId = entityId;
        this.institutionId = institutionId;
        this.nameEn = StringUtils.hasText((String)nameEn) ? nameEn : entityId;
        this.nameNl = StringUtils.hasText((String)nameNl) ? nameNl : this.nameEn;
        this.organisationNameEn = StringUtils.hasText((String)organisationNameEn) ? organisationNameEn : "";
        this.organisationNameNl = StringUtils.hasText((String)organisationNameNl) ? organisationNameNl : this.organisationNameEn;
        this.policyEnforcementDecisionRequired = policyEnforcementDecisionRequired;
        this.allowedAll = allowedAll;
        this.allowedEntityIds = allowedEntityIds;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String getNameEn() {
        return this.nameEn;
    }

    public String getNameNl() {
        return this.nameNl;
    }

    public String getInstitutionId() {
        return this.institutionId;
    }

    public boolean isPolicyEnforcementDecisionRequired() {
        return this.policyEnforcementDecisionRequired;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAllowedFrom(String ... entityIds) {
        if (this.allowedAll) return true;
        if (!Arrays.stream(entityIds).anyMatch(this.allowedEntityIds::contains)) return false;
        return true;
    }

    public String getOrganisationNameEn() {
        return this.organisationNameEn;
    }

    public String getOrganisationNameNl() {
        return this.organisationNameNl;
    }
}

