/*
 * Decompiled with CFR 0.152.
 */
package pdp.sab;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class SabClient {
    private static final Logger LOG = LoggerFactory.getLogger(SabClient.class);
    private final String sabRestEndpoint;
    private final RestTemplate restTemplate;

    public SabClient(String sabUserName, String sabPassword, String sabEndpoint) {
        if (!((String)sabEndpoint).endsWith("/")) {
            sabEndpoint = (String)sabEndpoint + "/";
        }
        this.sabRestEndpoint = sabEndpoint = (String)sabEndpoint + "api/profile?uid={uid}&idp={idp}";
        this.restTemplate = new RestTemplate();
        this.restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(sabUserName, sabPassword));
    }

    public List<String> roles(String userId) {
        Map result;
        String[] splitted = userId.split(":");
        if (splitted.length < 3) {
            throw new IllegalArgumentException(String.format("Illegal userId. Not a valid unspecified %s", userId));
        }
        String uid = splitted[splitted.length - 1];
        String idp = splitted[splitted.length - 2];
        LOG.debug("Starting to fetch SAB roles for schacHome {} for uid {} using templateURI {}", new Object[]{idp, userId, this.sabRestEndpoint});
        try {
            result = (Map)this.restTemplate.getForObject(this.sabRestEndpoint, Map.class, new Object[]{uid, idp});
        }
        catch (RestClientException e) {
            LOG.error("Error from restTemplate in SabClient", (Throwable)e);
            throw e;
        }
        if (result == null || !result.containsKey("message") || !result.get("message").equals("OK")) {
            LOG.warn("Error from SAB roles for {} from {}. Returning empty List", (Object)userId, (Object)this.sabRestEndpoint);
            return Collections.emptyList();
        }
        List profiles = (List)result.get("profiles");
        if (CollectionUtils.isEmpty((Collection)profiles)) {
            LOG.debug("Empty result from SAB roles for {} from {}.", (Object)userId, (Object)this.sabRestEndpoint);
            return Collections.emptyList();
        }
        Map profile = (Map)profiles.getFirst();
        List sabRoles = this.getAuthorisationEntitlements(profile);
        LOG.debug("Result {} from SAB roles for {} from {}.", new Object[]{sabRoles, userId, this.sabRestEndpoint});
        return sabRoles;
    }

    private List<String> getAuthorisationEntitlements(Map<String, Object> profile) {
        if (profile.containsKey("authorisations")) {
            List authorisations = (List)profile.get("authorisations");
            return authorisations.stream().map(m -> (String)m.get("role")).toList();
        }
        return new ArrayList<String>();
    }
}

