/*
 * Decompiled with CFR 0.152.
 */
package pdp;

import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import pdp.repositories.PdpPolicyViolationRepository;

public class PolicyViolationRetentionPeriodCleaner {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyViolationRetentionPeriodCleaner.class);

    @Autowired
    public PolicyViolationRetentionPeriodCleaner(int retentionPeriodDays, PdpPolicyViolationRepository pdpPolicyViolationRepository, boolean pdpCronJobResponsible) {
        if (pdpCronJobResponsible) {
            Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> this.clean(retentionPeriodDays, pdpPolicyViolationRepository), 0L, 1L, TimeUnit.DAYS);
        }
    }

    private void clean(int retentionPeriodDays, PdpPolicyViolationRepository pdpPolicyViolationRepository) {
        LOG.info("Start deleting policy violations older then {} days. Current # of policy violations is {}", (Object)retentionPeriodDays, (Object)pdpPolicyViolationRepository.count());
        int deleted = pdpPolicyViolationRepository.deleteOlderThenRetentionDays(retentionPeriodDays);
        LOG.info("Finished deleting policy violations older then {} days. Deleted {} policy violations", (Object)retentionPeriodDays, (Object)deleted);
    }
}

