/*
 * Decompiled with CFR 0.152.
 */
package pdp.ip;

import java.util.List;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.XACML;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.policy.FunctionDefinition;
import org.apache.openaz.xacml.std.IdentifierImpl;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.DataTypeBoolean;
import org.springframework.security.web.util.matcher.IpAddressMatcher;

public class IPRangeFunctionDefinition
implements FunctionDefinition {
    private static final IdentifierImpl IDENTIFIER = new IdentifierImpl("urn:surfnet:cbac:custom:function:3.0:ip:range");

    public Identifier getId() {
        return IDENTIFIER;
    }

    public Identifier getDataTypeId() {
        return XACML.ID_DATATYPE_BOOLEAN;
    }

    public boolean returnsBag() {
        return false;
    }

    public ExpressionResult evaluate(EvaluationContext evaluationContext, List<FunctionArgument> arguments) {
        AttributeValue attributeValue;
        if (arguments.size() != 2) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR));
        }
        String cidr = (String)String.class.cast(arguments.get(0).getValue().getValue());
        String ipAddress = (String)String.class.cast(arguments.get(1).getValue().getValue());
        IpAddressMatcher matcher = new IpAddressMatcher(cidr);
        try {
            attributeValue = matcher.matches(ipAddress) ? DataTypeBoolean.AV_TRUE : DataTypeBoolean.AV_FALSE;
        }
        catch (IllegalArgumentException e) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, "Invalid IP address: ".concat(ipAddress)));
        }
        return ExpressionResult.newSingle((AttributeValue)attributeValue);
    }
}

