/*
 * Decompiled with CFR 0.152.
 */
package pdp.conflicts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.springframework.util.CollectionUtils;
import pdp.domain.PdpPolicyDefinition;

public class PolicyConflictService {
    public Map<String, List<PdpPolicyDefinition>> conflicts(List<PdpPolicyDefinition> policies) {
        HashSet conflicts = new HashSet();
        IntStream.range(0, policies.size()).forEach(i -> IntStream.range(i + 1, policies.size()).forEach(j -> {
            PdpPolicyDefinition two;
            PdpPolicyDefinition one = (PdpPolicyDefinition)policies.get(i);
            if (this.conflict(one, two = (PdpPolicyDefinition)policies.get(j))) {
                conflicts.addAll(Arrays.asList(one, two));
            }
        }));
        HashMap<String, List<PdpPolicyDefinition>> result = new HashMap<String, List<PdpPolicyDefinition>>();
        conflicts.forEach(conflict -> conflict.getServiceProviderNames().forEach(name -> {
            if (result.containsKey(name)) {
                List value = (List)result.get(name);
                value.add(conflict);
            } else {
                ArrayList<PdpPolicyDefinition> value = new ArrayList<PdpPolicyDefinition>();
                value.add((PdpPolicyDefinition)conflict);
                result.put((String)name, (List<PdpPolicyDefinition>)value);
            }
        }));
        return result;
    }

    private boolean conflict(PdpPolicyDefinition one, PdpPolicyDefinition two) {
        return one.getType().equals(two.getType()) && this.overlapping(one.getServiceProviderIds(), two.getServiceProviderIds()) && (CollectionUtils.isEmpty((Collection)one.getIdentityProviderIds()) || CollectionUtils.isEmpty((Collection)two.getIdentityProviderIds()) || this.overlapping(one.getIdentityProviderIds(), two.getIdentityProviderIds()));
    }

    private boolean overlapping(List<String> idps, List<String> otherIdps) {
        return otherIdps.stream().map(idp -> idps.stream().anyMatch(s -> s.equals(idp))).anyMatch(b -> b);
    }
}

