/*
 * Decompiled with CFR 0.152.
 */
package provisioning.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import provisioning.model.HttpMethod;
import provisioning.model.Provisioning;
import provisioning.model.ProvisioningType;
import provisioning.model.ResourceType;
import provisioning.repository.ProvisioningRepository;

@RestController
@RequestMapping(value={"/graph"}, produces={"application/json"})
public class GraphController {
    private static final Log LOG = LogFactory.getLog(GraphController.class);
    private final ProvisioningRepository provisioningRepository;
    private final ObjectMapper objectMapper;

    @Autowired
    public GraphController(ProvisioningRepository provisioningRepository, ObjectMapper objectMapper) {
        this.provisioningRepository = provisioningRepository;
        this.objectMapper = objectMapper;
    }

    @PostMapping(value={"/users"})
    public ResponseEntity<Map<String, String>> createUser(@RequestBody Map<String, Object> user) {
        LOG.info((Object)("/graph/users POST " + user));
        String id = UUID.randomUUID().toString();
        this.provisioningRepository.save((Object)new Provisioning(ProvisioningType.graph, this.objectMapper.valueToTree(user), HttpMethod.POST, ResourceType.USERS, "/graph/users"));
        return ResponseEntity.ok(Collections.singletonMap("id", id));
    }
}

