/*
 * Decompiled with CFR 0.152.
 */
package provisioning.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import provisioning.model.GuestAccount;
import provisioning.model.HttpMethod;
import provisioning.model.Provisioning;
import provisioning.model.ProvisioningType;
import provisioning.model.ResourceType;
import provisioning.repository.ProvisioningRepository;

@RestController
@RequestMapping(value={"/eva"})
public class EVAController {
    private static final Log LOG = LogFactory.getLog(EVAController.class);
    private final ProvisioningRepository provisioningRepository;
    private final ObjectMapper objectMapper;

    @Autowired
    public EVAController(ProvisioningRepository provisioningRepository, ObjectMapper objectMapper) {
        this.provisioningRepository = provisioningRepository;
        this.objectMapper = objectMapper;
    }

    @PostMapping(value={"/api/v1/guest/create"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<Map<String, Object>> createUser(GuestAccount guestAccount) throws JsonProcessingException {
        LOG.info((Object)("eva/api/v1/guest/create POST " + guestAccount));
        String id = UUID.randomUUID().toString();
        guestAccount.setId(id);
        Map user = (Map)this.objectMapper.convertValue((Object)guestAccount, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.provisioningRepository.save((Object)new Provisioning(ProvisioningType.eva, this.objectMapper.valueToTree((Object)user), HttpMethod.DELETE, ResourceType.USERS, "eva/api/v1/guest/create"));
        return ResponseEntity.ok((Object)user);
    }

    @PostMapping(value={"/api/v1/guest/disable/{id}"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<Void> disableUser(@PathVariable(value="id") String id) {
        LOG.info((Object)("eva/api/v1/guest/disable POST " + id));
        this.provisioningRepository.save((Object)new Provisioning(ProvisioningType.eva, this.objectMapper.valueToTree(Map.of("id", id)), HttpMethod.POST, ResourceType.USERS, "/api/v1/guest/disable/" + id));
        return ResponseEntity.ok().build();
    }
}

