/*
 * Decompiled with CFR 0.152.
 */
package provisioning.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import provisioning.model.HttpMethod;
import provisioning.model.Provisioning;
import provisioning.model.ProvisioningType;
import provisioning.model.ResourceType;
import provisioning.repository.ProvisioningRepository;

@RestController
@RequestMapping(value={"/api/scim/v2"}, produces={"application/json"})
public class SCIMController {
    private static final Log LOG = LogFactory.getLog(SCIMController.class);
    private final ProvisioningRepository provisioningRepository;
    private final ObjectMapper objectMapper;

    @Autowired
    public SCIMController(ProvisioningRepository provisioningRepository, ObjectMapper objectMapper) {
        this.provisioningRepository = provisioningRepository;
        this.objectMapper = objectMapper;
    }

    @PostMapping(value={"/users"})
    public ResponseEntity<Map<String, String>> createUser(@RequestBody Map<String, Object> user) {
        LOG.info((Object)("/api/scim/v2/users POST " + user));
        this.provisioningRepository.save((Object)new Provisioning(ProvisioningType.scim, this.objectMapper.valueToTree(user), HttpMethod.POST, ResourceType.USERS, "/api/scim/v2/users"));
        String id = UUID.randomUUID().toString();
        return ResponseEntity.ok(Collections.singletonMap("id", id));
    }

    @PutMapping(value={"/users/{id}"})
    public ResponseEntity<Map<String, String>> updateUser(@PathVariable(value="id") String id, @RequestBody Map<String, Object> user) {
        LOG.info((Object)("/api/scim/v2/users/" + id + " PUT " + user));
        this.provisioningRepository.save((Object)new Provisioning(ProvisioningType.scim, this.objectMapper.valueToTree(user), HttpMethod.PUT, ResourceType.USERS, "/api/scim/v2/users/" + id));
        return ResponseEntity.ok(Collections.singletonMap("id", id));
    }

    @DeleteMapping(value={"/users/{id}"})
    public ResponseEntity<Void> deleteUser(@PathVariable(value="id") String id) {
        LOG.info((Object)("/api/scim/v2/users/" + id + " DELETE"));
        this.provisioningRepository.save((Object)new Provisioning(ProvisioningType.scim, this.objectMapper.valueToTree(Map.of("id", id)), HttpMethod.DELETE, ResourceType.USERS, "/api/scim/v2/users/" + id));
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
    }

    @PostMapping(value={"/groups"})
    public ResponseEntity<Map<String, String>> createGroup(@RequestBody Map<String, Object> group) {
        LOG.info((Object)("/api/scim/v2/groups POST " + group));
        String id = UUID.randomUUID().toString();
        this.provisioningRepository.save((Object)new Provisioning(ProvisioningType.scim, this.objectMapper.valueToTree(group), HttpMethod.POST, ResourceType.GROUPS, "/api/scim/v2/groups"));
        return ResponseEntity.ok(Collections.singletonMap("id", id));
    }

    @PatchMapping(value={"/groups/{id}"})
    public ResponseEntity<Map<String, String>> patchGroup(@PathVariable(value="id") String id, @RequestBody Map<String, Object> group) {
        LOG.info((Object)("/api/scim/v2/groups/" + id + " PATCH " + group));
        this.provisioningRepository.save((Object)new Provisioning(ProvisioningType.scim, this.objectMapper.valueToTree(group), HttpMethod.PATCH, ResourceType.GROUPS, "/api/scim/v2/groups/" + id));
        return ResponseEntity.ok(Collections.singletonMap("id", id));
    }

    @PutMapping(value={"/groups/{id}"})
    public ResponseEntity<Map<String, String>> updateGroup(@PathVariable(value="id") String id, @RequestBody Map<String, Object> group) {
        LOG.info((Object)("/api/scim/v2/groups/" + id + " PUT " + group));
        this.provisioningRepository.save((Object)new Provisioning(ProvisioningType.scim, this.objectMapper.valueToTree(group), HttpMethod.PUT, ResourceType.GROUPS, "/api/scim/v2/groups/" + id));
        return ResponseEntity.ok(Collections.singletonMap("id", id));
    }

    @DeleteMapping(value={"/groups/{id}"})
    public ResponseEntity<Void> deleteGroup(@PathVariable(value="id") String id) {
        LOG.info((Object)("/api/scim/v2/groups/" + id + " DELETE"));
        this.provisioningRepository.save((Object)new Provisioning(ProvisioningType.scim, this.objectMapper.valueToTree(Map.of("id", id)), HttpMethod.DELETE, ResourceType.GROUPS, "/api/scim/v2/groups/" + id));
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
    }
}

