/*
 * Decompiled with CFR 0.152.
 */
package saml.crypto;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import saml.crypto.X509Utilities;

public class KeyStoreLocator {
    private KeyStoreLocator() {
    }

    public static KeyStore createKeyStore(String name, String certificate, String privateKey, String passPhrase) {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, passPhrase.toCharArray());
        byte[] certBytes = X509Utilities.getDER(certificate);
        X509Certificate cert = X509Utilities.getCertificate(certBytes);
        ks.setCertificateEntry(name, cert);
        PrivateKey pkey = X509Utilities.readPrivateKey(privateKey);
        ks.setKeyEntry(name, pkey, passPhrase.toCharArray(), new Certificate[]{cert});
        return ks;
    }
}

