/*
 * Decompiled with CFR 0.152.
 */
package saml;

import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.xml.ParserPool;
import net.shibboleth.shared.xml.SerializeSupport;
import net.shibboleth.shared.xml.impl.BasicParserPool;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.impl.XSStringBuilder;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.ext.saml2mdui.Description;
import org.opensaml.saml.ext.saml2mdui.DisplayName;
import org.opensaml.saml.ext.saml2mdui.Logo;
import org.opensaml.saml.ext.saml2mdui.UIInfo;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AttributeValue;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthenticatingAuthority;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.StatusDetail;
import org.opensaml.saml.saml2.core.StatusMessage;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.Organization;
import org.opensaml.saml.saml2.metadata.OrganizationDisplayName;
import org.opensaml.saml.saml2.metadata.OrganizationName;
import org.opensaml.saml.saml2.metadata.OrganizationURL;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.credential.impl.KeyStoreCredentialResolver;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.X509Data;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureSupport;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.opensaml.xmlsec.signature.support.Signer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import saml.SAMLService;
import saml.crypto.KeyStoreLocator;
import saml.crypto.X509Utilities;
import saml.model.SAMLAttribute;
import saml.model.SAMLConfiguration;
import saml.model.SAMLIdentityProvider;
import saml.model.SAMLServiceProvider;
import saml.model.SAMLStatus;
import saml.parser.EncodingUtils;
import saml.parser.OpenSamlVelocityEngine;

public class DefaultSAMLService
implements SAMLService {
    public static final String authnContextClassRefPassword = "urn:oasis:names:tc:SAML:2.0:ac:classes:Password";
    public static final String authnContextClassRefUnspecified = "urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified";
    private static final Logger LOG;
    private final OpenSamlVelocityEngine velocityEngine = new OpenSamlVelocityEngine();
    private final SAMLSignatureProfileValidator samlSignatureProfileValidator = new SAMLSignatureProfileValidator();
    private final BasicParserPool parserPool;
    private final Map<String, SAMLServiceProvider> serviceProviders = new HashMap<String, SAMLServiceProvider>();
    private final SAMLConfiguration configuration;
    private final Duration skewTime = Duration.ofMinutes(5L);
    private final Credential signingCredential;

    public DefaultSAMLService(SAMLConfiguration configuration) {
        SAMLIdentityProvider identityProvider = configuration.getIdentityProvider();
        String entityId = identityProvider.getEntityId();
        String secret = UUID.randomUUID().toString();
        KeyStore keyStore = KeyStoreLocator.createKeyStore(entityId, identityProvider.getCertificate(), identityProvider.getPrivateKey(), secret);
        KeyStoreCredentialResolver resolver = new KeyStoreCredentialResolver(keyStore, Map.of(entityId, secret), UsageType.SIGNING);
        this.signingCredential = resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityId), new UsageCriterion(UsageType.SIGNING)}));
        this.parserPool = new BasicParserPool();
        this.configuration = configuration;
        this.bootstrap();
        configuration.getServiceProviders().forEach(serviceProvider -> this.serviceProviders.put(serviceProvider.getEntityId(), this.resolveSigningCredential((SAMLServiceProvider)serviceProvider)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bootstrap() {
        this.parserPool.setMaxPoolSize(50);
        this.parserPool.setCoalescing(true);
        this.parserPool.setExpandEntityReferences(false);
        this.parserPool.setIgnoreComments(true);
        this.parserPool.setIgnoreElementContentWhitespace(true);
        this.parserPool.setNamespaceAware(true);
        this.parserPool.setSchema(null);
        this.parserPool.setDTDValidating(false);
        this.parserPool.setXincludeAware(false);
        HashMap builderAttributes = new HashMap();
        this.parserPool.setBuilderAttributes(builderAttributes);
        Map<String, Boolean> parserBuilderFeatures = DefaultSAMLService.getParserBuilderFeatures();
        this.parserPool.setBuilderFeatures(parserBuilderFeatures);
        this.parserPool.initialize();
        InitializationService.initialize();
        Class<ConfigurationService> clazz = ConfigurationService.class;
        synchronized (ConfigurationService.class) {
            XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
            registry.setParserPool((ParserPool)this.parserPool);
            // ** MonitorExit[var3_4] (shouldn't be in output)
        }
        {
            return;
        }
    }

    private UnmarshallerFactory getUnmarshallerFactory() {
        return XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
    }

    private static Map<String, Boolean> getParserBuilderFeatures() {
        HashMap<String, Boolean> parserBuilderFeatures = new HashMap<String, Boolean>();
        parserBuilderFeatures.put("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
        parserBuilderFeatures.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        parserBuilderFeatures.put("http://xml.org/sax/features/external-general-entities", Boolean.FALSE);
        parserBuilderFeatures.put("http://apache.org/xml/features/validation/schema/normalized-value", Boolean.FALSE);
        parserBuilderFeatures.put("http://xml.org/sax/features/external-parameter-entities", Boolean.FALSE);
        parserBuilderFeatures.put("http://apache.org/xml/features/dom/defer-node-expansion", Boolean.FALSE);
        return parserBuilderFeatures;
    }

    private void validateSignature(SignableSAMLObject target, Credential credential, boolean signatureRequired) {
        Signature signature = target.getSignature();
        if (signature == null) {
            if (signatureRequired) {
                throw new SignatureException("Signature element not found.");
            }
        } else {
            this.samlSignatureProfileValidator.validate(signature);
            SignatureValidator.validate((Signature)signature, (Credential)credential);
        }
    }

    private SAMLServiceProvider getSAMLServiceProvider(String entityId) {
        return this.serviceProviders.computeIfAbsent(entityId, key -> this.resolveSigningCredential(this.configuration.getServiceProviders().stream().filter(samlServiceProvider -> samlServiceProvider.getEntityId().equals(entityId)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown SP entity: " + entityId))));
    }

    private XMLObject parseXMLObject(String xml, boolean encoded, boolean deflated) {
        if (encoded) {
            xml = EncodingUtils.samlDecode(xml, deflated);
        }
        Document document = this.parserPool.parse((InputStream)new ByteArrayInputStream(xml.getBytes()));
        Element element = document.getDocumentElement();
        return this.getUnmarshallerFactory().getUnmarshaller(element).unmarshall(element);
    }

    @Override
    public AuthnRequest parseAuthnRequest(String xml, boolean encoded, boolean deflated) {
        AuthnRequest authnRequest = (AuthnRequest)this.parseXMLObject(xml, encoded, deflated);
        SAMLServiceProvider serviceProvider = this.getSAMLServiceProvider(authnRequest.getIssuer().getValue());
        if (!serviceProvider.getAcsLocation().equalsIgnoreCase(authnRequest.getAssertionConsumerServiceURL())) {
            throw new IllegalArgumentException(String.format("ACS locations (%s, %s) does not match", serviceProvider.getAcsLocation(), authnRequest.getAssertionConsumerServiceURL()));
        }
        this.validateSignature((SignableSAMLObject)authnRequest, serviceProvider.getCredential(), this.configuration.isRequiresSignedAuthnRequest());
        return authnRequest;
    }

    @Override
    public String createAuthnRequest(SAMLServiceProvider serviceProvider, String destination, boolean signRequest, boolean forceAuthn, String authnContextClassRef) {
        AuthnRequest authnRequest = this.buildSAMLObject(AuthnRequest.class);
        authnRequest.setAssertionConsumerServiceURL(serviceProvider.getAcsLocation());
        authnRequest.setDestination(destination);
        authnRequest.setForceAuthn(Boolean.valueOf(forceAuthn));
        authnRequest.setID("A" + String.valueOf(UUID.randomUUID()));
        authnRequest.setIsPassive(Boolean.valueOf(false));
        authnRequest.setIssueInstant(Instant.now());
        authnRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        authnRequest.setVersion(SAMLVersion.VERSION_20);
        Issuer issuer = this.buildSAMLObject(Issuer.class);
        issuer.setValue(serviceProvider.getEntityId());
        authnRequest.setIssuer(issuer);
        if (StringUtils.isNotEmpty((CharSequence)authnContextClassRef)) {
            RequestedAuthnContext requestedAuthnContext = this.buildSAMLObject(RequestedAuthnContext.class);
            AuthnContextClassRef newAuthnContextClassRef = this.buildSAMLObject(AuthnContextClassRef.class);
            newAuthnContextClassRef.setURI(authnContextClassRef);
            requestedAuthnContext.getAuthnContextClassRefs().add(newAuthnContextClassRef);
            authnRequest.setRequestedAuthnContext(requestedAuthnContext);
        }
        if (signRequest) {
            this.signObject((SignableSAMLObject)authnRequest, serviceProvider.getCredential());
        }
        Element element = XMLObjectSupport.marshall((XMLObject)authnRequest);
        String samlAuthnRequest = SerializeSupport.nodeToString((Node)element);
        return EncodingUtils.deflatedBase64encoded(samlAuthnRequest);
    }

    @Override
    public Response parseResponse(String xml) {
        Response response = (Response)this.parseXMLObject(xml, true, false);
        this.validateSignature((SignableSAMLObject)response, this.signingCredential, this.configuration.isRequiresSignedResponse());
        return response;
    }

    private KeyInfoGenerator getKeyInfoGenerator(Credential credential) {
        NamedKeyInfoGeneratorManager manager = DefaultSecurityConfigurationBootstrap.buildBasicKeyInfoGeneratorManager();
        return manager.getDefaultManager().getFactory(credential).newInstance();
    }

    protected void signObject(SignableSAMLObject signable, Credential credential) {
        Signature signature = this.buildSAMLObject(Signature.class);
        signable.setSignature(signature);
        SignatureSigningParameters signingParameters = new SignatureSigningParameters();
        signingParameters.setSigningCredential(credential);
        signingParameters.setKeyInfoGenerator(this.getKeyInfoGenerator(credential));
        signingParameters.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512");
        signingParameters.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        signingParameters.setSignatureReferenceDigestMethod("http://www.w3.org/2001/04/xmlenc#sha512");
        SignatureSupport.prepareSignatureParams((Signature)signature, (SignatureSigningParameters)signingParameters);
        Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)signable);
        marshaller.marshall((XMLObject)signable);
        Signer.signObject((Signature)signature);
    }

    private <T extends XMLObject> T buildSAMLObject(Class<T> clazz) {
        QName defaultElementName = (QName)clazz.getDeclaredField("DEFAULT_ELEMENT_NAME").get(null);
        return (T)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(defaultElementName).buildObject(defaultElementName);
    }

    @Override
    public void sendResponse(String spEntityID, String inResponseTo, String nameId, SAMLStatus status, String relayState, String optionalMessage, String authnContextClassRefValue, List<SAMLAttribute> samlAttributes, HttpServletResponse servletResponse) {
        SAMLServiceProvider serviceProvider = this.getSAMLServiceProvider(spEntityID);
        Instant now = Instant.now();
        Instant notOnOrAfter = now.plus(this.skewTime);
        Instant notBefore = now.minus(this.skewTime);
        Response response = this.buildSAMLObject(Response.class);
        String acsLocation = serviceProvider.getAcsLocation();
        response.setDestination(acsLocation);
        response.setID("RP" + String.valueOf(UUID.randomUUID()));
        response.setInResponseTo(inResponseTo);
        response.setIssueInstant(now);
        Issuer issuer = this.buildSAMLObject(Issuer.class);
        String idpEntityID = this.configuration.getIdentityProvider().getEntityId();
        issuer.setValue(idpEntityID);
        issuer.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        response.setIssuer(issuer);
        response.setVersion(SAMLVersion.VERSION_20);
        Status newStatus = this.buildSAMLObject(Status.class);
        StatusCode statusCode = this.buildSAMLObject(StatusCode.class);
        if (status.equals((Object)SAMLStatus.NO_AUTHN_CONTEXT)) {
            statusCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Responder");
            StatusCode innerStatusCode = this.buildSAMLObject(StatusCode.class);
            innerStatusCode.setValue(SAMLStatus.NO_AUTHN_CONTEXT.getStatus());
            statusCode.setStatusCode(innerStatusCode);
        } else {
            statusCode.setValue(status.getStatus());
        }
        newStatus.setStatusCode(statusCode);
        if (StringUtils.isNotEmpty((CharSequence)optionalMessage)) {
            StatusMessage statusMessage = this.buildSAMLObject(StatusMessage.class);
            statusMessage.setValue(optionalMessage);
            newStatus.setStatusMessage(statusMessage);
            StatusDetail statusDetail = this.buildSAMLObject(StatusDetail.class);
            XSStringBuilder stringBuilder = (XSStringBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(XSString.TYPE_NAME);
            XSString stringValue = (XSString)stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
            stringValue.setValue(optionalMessage);
            statusDetail.getUnknownXMLObjects().add(stringValue);
            newStatus.setStatusDetail(statusDetail);
        }
        response.setStatus(newStatus);
        if (status.equals((Object)SAMLStatus.SUCCESS)) {
            Assertion assertion = this.buildSAMLObject(Assertion.class);
            Issuer newIssuer = this.buildSAMLObject(Issuer.class);
            newIssuer.setValue(idpEntityID);
            newIssuer.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
            assertion.setIssuer(newIssuer);
            assertion.setID("A" + String.valueOf(UUID.randomUUID()));
            assertion.setIssueInstant(now);
            assertion.setVersion(SAMLVersion.VERSION_20);
            Subject subject = this.buildSAMLObject(Subject.class);
            NameID nameID = this.buildSAMLObject(NameID.class);
            nameID.setValue(nameId);
            nameID.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
            subject.setNameID(nameID);
            SubjectConfirmation subjectConfirmation = this.buildSAMLObject(SubjectConfirmation.class);
            subjectConfirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
            SubjectConfirmationData subjectConfirmationData = this.buildSAMLObject(SubjectConfirmationData.class);
            subjectConfirmationData.setInResponseTo(inResponseTo);
            subjectConfirmationData.setNotOnOrAfter(notOnOrAfter);
            subjectConfirmationData.setNotBefore(notBefore);
            subjectConfirmationData.setRecipient(acsLocation);
            subjectConfirmation.setSubjectConfirmationData(subjectConfirmationData);
            subject.getSubjectConfirmations().add(subjectConfirmation);
            assertion.setSubject(subject);
            Conditions conditions = this.buildSAMLObject(Conditions.class);
            conditions.setNotBefore(notBefore);
            conditions.setNotOnOrAfter(notOnOrAfter);
            AudienceRestriction audienceRestriction = this.buildSAMLObject(AudienceRestriction.class);
            Audience audience = this.buildSAMLObject(Audience.class);
            audience.setURI(spEntityID);
            audienceRestriction.getAudiences().add(audience);
            conditions.getAudienceRestrictions().add(audienceRestriction);
            assertion.setConditions(conditions);
            AuthnStatement authnStatement = this.buildSAMLObject(AuthnStatement.class);
            authnStatement.setAuthnInstant(now);
            authnStatement.setSessionIndex("IDX" + String.valueOf(UUID.randomUUID()));
            authnStatement.setSessionNotOnOrAfter(notOnOrAfter);
            AuthnContext authnContext = this.buildSAMLObject(AuthnContext.class);
            AuthnContextClassRef authnContextClassRef = this.buildSAMLObject(AuthnContextClassRef.class);
            authnContextClassRef.setURI(authnContextClassRefValue);
            authnContext.setAuthnContextClassRef(authnContextClassRef);
            AuthenticatingAuthority authenticatingAuthority = this.buildSAMLObject(AuthenticatingAuthority.class);
            authenticatingAuthority.setURI(idpEntityID);
            authnContext.getAuthenticatingAuthorities().add(authenticatingAuthority);
            authnStatement.setAuthnContext(authnContext);
            assertion.getAuthnStatements().add(authnStatement);
            AttributeStatement attributeStatement = this.buildSAMLObject(AttributeStatement.class);
            List attributes = attributeStatement.getAttributes();
            Map<String, List<SAMLAttribute>> groupedSAMLAttributes = samlAttributes.stream().collect(Collectors.groupingBy(SAMLAttribute::getName));
            XSStringBuilder stringBuilder = (XSStringBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(XSString.TYPE_NAME);
            groupedSAMLAttributes.forEach((name, values) -> {
                Attribute attribute = this.buildSAMLObject(Attribute.class);
                attribute.setName(name);
                attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
                attribute.getAttributeValues().addAll(values.stream().map(value -> {
                    XSString stringValue = (XSString)stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
                    stringValue.setValue(value.getValue());
                    return stringValue;
                }).collect(Collectors.toList()));
                attributes.add(attribute);
            });
            assertion.getAttributeStatements().add(attributeStatement);
            this.signObject((SignableSAMLObject)assertion, this.signingCredential);
            response.getAssertions().add(assertion);
        }
        this.signObject((SignableSAMLObject)response, this.signingCredential);
        Element element = XMLObjectSupport.marshall((XMLObject)response);
        String samlResponse = SerializeSupport.nodeToString((Node)element);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("action", acsLocation);
        String encoded = EncodingUtils.samlEncode(samlResponse);
        model.put("SAMLResponse", encoded);
        if (StringUtils.isNotEmpty((CharSequence)relayState)) {
            model.put("RelayState", EncodingUtils.toISO8859_1(StringEscapeUtils.escapeHtml4((String)relayState)));
        }
        servletResponse.setContentType("text/html");
        servletResponse.setCharacterEncoding(StandardCharsets.UTF_8.name());
        servletResponse.setHeader("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
        servletResponse.setHeader("Pragma", "no-cache");
        servletResponse.setHeader("Expires", "0");
        StringWriter out = new StringWriter();
        this.velocityEngine.process(model, out);
        servletResponse.getWriter().write(out.toString());
    }

    @Override
    public String metaData(String singleSignOnServiceURI, String name, String description, String logoURI) {
        EntityDescriptor entityDescriptor = this.buildSAMLObject(EntityDescriptor.class);
        entityDescriptor.setEntityID(this.configuration.getIdentityProvider().getEntityId());
        entityDescriptor.setID("M" + String.valueOf(UUID.randomUUID()));
        entityDescriptor.setValidUntil(Instant.now().plus(730L, ChronoUnit.DAYS));
        IDPSSODescriptor idpssoDescriptor = this.buildSAMLObject(IDPSSODescriptor.class);
        Extensions extensions = this.buildSAMLObject(Extensions.class);
        UIInfo uiInfo = this.buildSAMLObject(UIInfo.class);
        List.of("en", "nl").forEach(lang -> {
            Description newDescription = this.buildSAMLObject(Description.class);
            newDescription.setValue(description);
            newDescription.setXMLLang(lang);
            uiInfo.getDescriptions().add(newDescription);
            DisplayName newDisplayName = this.buildSAMLObject(DisplayName.class);
            newDisplayName.setValue(description);
            newDisplayName.setXMLLang(lang);
            uiInfo.getDisplayNames().add(newDisplayName);
        });
        Logo logo = this.buildSAMLObject(Logo.class);
        logo.setHeight(Integer.valueOf(160));
        logo.setWidth(Integer.valueOf(200));
        logo.setURI(logoURI);
        uiInfo.getLogos().add(logo);
        extensions.getUnknownXMLObjects().add(uiInfo);
        idpssoDescriptor.setExtensions(extensions);
        NameIDFormat nameIDFormat = this.buildSAMLObject(NameIDFormat.class);
        nameIDFormat.setURI("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        idpssoDescriptor.getNameIDFormats().add(nameIDFormat);
        idpssoDescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        SingleSignOnService singleSignOnService = this.buildSAMLObject(SingleSignOnService.class);
        singleSignOnService.setLocation(singleSignOnServiceURI);
        singleSignOnService.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        idpssoDescriptor.getSingleSignOnServices().add(singleSignOnService);
        X509KeyInfoGeneratorFactory keyInfoGeneratorFactory = new X509KeyInfoGeneratorFactory();
        keyInfoGeneratorFactory.setEmitEntityCertificate(true);
        KeyInfoGenerator keyInfoGenerator = keyInfoGeneratorFactory.newInstance();
        KeyDescriptor encKeyDescriptor = this.buildSAMLObject(KeyDescriptor.class);
        encKeyDescriptor.setUse(UsageType.SIGNING);
        encKeyDescriptor.setKeyInfo(keyInfoGenerator.generate(this.signingCredential));
        idpssoDescriptor.getKeyDescriptors().add(encKeyDescriptor);
        entityDescriptor.getRoleDescriptors().add(idpssoDescriptor);
        Organization organization = this.buildSAMLObject(Organization.class);
        List.of("en", "nl").forEach(lang -> {
            OrganizationName organizationName = this.buildSAMLObject(OrganizationName.class);
            organizationName.setValue(name);
            organizationName.setXMLLang(lang);
            organization.getOrganizationNames().add(organizationName);
            OrganizationDisplayName organizationDisplayName = this.buildSAMLObject(OrganizationDisplayName.class);
            organizationDisplayName.setValue(name);
            organizationDisplayName.setXMLLang(lang);
            organization.getDisplayNames().add(organizationDisplayName);
            OrganizationURL organizationURL = this.buildSAMLObject(OrganizationURL.class);
            organizationURL.setURI("https://www.surf.nl/" + (lang.equals("en") ? "en" : ""));
            organizationURL.setXMLLang(lang);
            organization.getURLs().add(organizationURL);
        });
        entityDescriptor.setOrganization(organization);
        this.signObject((SignableSAMLObject)entityDescriptor, this.signingCredential);
        Element element = XMLObjectSupport.marshall((XMLObject)entityDescriptor);
        return SerializeSupport.nodeToString((Node)element);
    }

    @Override
    public SAMLServiceProvider resolveSigningCredential(SAMLServiceProvider serviceProvider) {
        try {
            String xml = IOUtils.toString((URL)new URL(serviceProvider.getMetaDataUrl()), (Charset)Charset.defaultCharset());
            EntityDescriptor entityDescriptor = (EntityDescriptor)this.parseXMLObject(xml, false, false);
            String acsLocation = ((AssertionConsumerService)entityDescriptor.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol").getAssertionConsumerServices().get(0)).getLocation();
            serviceProvider.setAcsLocation(acsLocation);
            KeyDescriptor keyDescriptor = entityDescriptor.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol").getKeyDescriptors().stream().filter(kd -> kd.getUse().getValue().equals(UsageType.SIGNING.getValue())).findFirst().orElseThrow(IllegalArgumentException::new);
            org.opensaml.xmlsec.signature.X509Certificate x509Certificate = (org.opensaml.xmlsec.signature.X509Certificate)((X509Data)keyDescriptor.getKeyInfo().getX509Datas().get(0)).getX509Certificates().get(0);
            byte[] certBytes = X509Utilities.getDER(x509Certificate.getValue());
            X509Certificate certificate = X509Utilities.getCertificate(certBytes);
            BasicX509Credential signingCredential = new BasicX509Credential(certificate);
            serviceProvider.setCredential((Credential)signingCredential);
            return serviceProvider;
        }
        catch (IOException | RuntimeException e) {
            LOG.error("Error in resolving MetaData for metaData URL:" + serviceProvider.getMetaDataUrl(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String serviceProviderMetaData(SAMLServiceProvider serviceProvider) {
        EntityDescriptor entityDescriptor = this.buildSAMLObject(EntityDescriptor.class);
        entityDescriptor.setEntityID(serviceProvider.getEntityId());
        entityDescriptor.setID("M" + String.valueOf(UUID.randomUUID()));
        entityDescriptor.setValidUntil(Instant.now().plus(3650L, ChronoUnit.DAYS));
        SPSSODescriptor spssoDescriptor = this.buildSAMLObject(SPSSODescriptor.class);
        NameIDFormat nameIDFormat = this.buildSAMLObject(NameIDFormat.class);
        nameIDFormat.setURI("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        spssoDescriptor.getNameIDFormats().add(nameIDFormat);
        spssoDescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        AssertionConsumerService assertionConsumerService = this.buildSAMLObject(AssertionConsumerService.class);
        assertionConsumerService.setLocation(serviceProvider.getAcsLocation());
        assertionConsumerService.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        spssoDescriptor.getAssertionConsumerServices().add(assertionConsumerService);
        X509KeyInfoGeneratorFactory keyInfoGeneratorFactory = new X509KeyInfoGeneratorFactory();
        keyInfoGeneratorFactory.setEmitEntityCertificate(true);
        KeyInfoGenerator keyInfoGenerator = keyInfoGeneratorFactory.newInstance();
        KeyDescriptor encKeyDescriptor = this.buildSAMLObject(KeyDescriptor.class);
        encKeyDescriptor.setUse(UsageType.SIGNING);
        encKeyDescriptor.setKeyInfo(keyInfoGenerator.generate(serviceProvider.getCredential()));
        spssoDescriptor.getKeyDescriptors().add(encKeyDescriptor);
        entityDescriptor.getRoleDescriptors().add(spssoDescriptor);
        this.signObject((SignableSAMLObject)entityDescriptor, serviceProvider.getCredential());
        Element element = XMLObjectSupport.marshall((XMLObject)entityDescriptor);
        return SerializeSupport.nodeToString((Node)element);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        LOG = LoggerFactory.getLogger(DefaultSAMLService.class);
    }
}

