/*
 * Decompiled with CFR 0.152.
 */
package intake.config;

import intake.config.MockAuthorizationFilter;
import java.net.URI;
import java.util.Collections;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;

@EnableWebSecurity
public class SecurityConfig
extends WebSecurityConfigurerAdapter {
    private final Environment environment;
    private final String redirectUri;
    private final String acrValue;
    private final InMemoryClientRegistrationRepository clientRegistrationRepository;

    @Autowired
    public SecurityConfig(InMemoryClientRegistrationRepository clientRegistrationRepository, Environment environment, @Value(value="${spring.security.oauth2.client.registration.oidc.redirect-uri}") String redirectUri, @Value(value="${oidc.account_linking_context_class_ref}") String acrValue) {
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.environment = environment;
        this.redirectUri = URI.create(redirectUri).getPath();
        this.acrValue = acrValue;
    }

    public void configure(WebSecurity web) {
        web.ignoring().antMatchers(new String[]{"/actuator/**", "/intake/api/public/**", "/error"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        DefaultOAuth2AuthorizationRequestResolver authorizationRequestResolver = new DefaultOAuth2AuthorizationRequestResolver((ClientRegistrationRepository)this.clientRegistrationRepository, "/oauth2/authorization");
        authorizationRequestResolver.setAuthorizationRequestCustomizer(customizer -> customizer.additionalParameters(Collections.singletonMap("acr_values", this.acrValue)));
        ((HttpSecurity)http.csrf().disable()).authorizeRequests(authorize -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)authorize.anyRequest()).authenticated()).oauth2Login().redirectionEndpoint().baseUri(this.redirectUri).and().authorizationEndpoint().authorizationRequestResolver((OAuth2AuthorizationRequestResolver)authorizationRequestResolver);
        if (this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"test"}))) {
            http.addFilterBefore((Filter)new MockAuthorizationFilter(), AbstractPreAuthenticatedProcessingFilter.class);
        }
    }
}

