/*
 * Decompiled with CFR 0.152.
 */
package intake.repository;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import exception.NotFoundException;
import intake.model.Course;
import intake.model.Institution;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class CatalogRepository {
    private List<Institution> institutions;

    public CatalogRepository(@Value(value="${catalog.path}") Resource catalogResource) {
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        this.institutions = (List)objectMapper.readValue(catalogResource.getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<Institution> institutions() {
        return this.institutions;
    }

    public Institution findInstitutionBySchacHome(String schacHome) {
        return this.institutions.stream().filter(institution -> institution.getSchacHome().equals(schacHome)).findAny().orElseThrow(NotFoundException::new);
    }

    public Course findCourseByIdentifier(String identifier) {
        return this.institutions.stream().map(Institution::getCourses).flatMap(Collection::stream).filter(course -> course.getIdentifier().equals(identifier)).findAny().orElseThrow(NotFoundException::new);
    }
}

