/*
 * Decompiled with CFR 0.152.
 */
package teams.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import teams.domain.Team;

@Entity(name="external_groups")
public class ExternalTeam
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    private String description;
    @Column
    @NotNull
    private String groupProvider;
    @Column
    @NotNull
    private String identifier;
    @Column
    @NotNull
    private String name;
    @Column(name="admin_name")
    private String adminName;
    @Column(name="created_at")
    private Instant createdAt;
    @ManyToMany
    @JoinTable(name="team_external_groups", joinColumns={@JoinColumn(name="external_groups_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="team_id", referencedColumnName="id")})
    @JsonIgnore
    private Set<Team> teams = new HashSet();

    public ExternalTeam(String description, String groupProvider, String identifier, String name) {
        this.description = description;
        this.groupProvider = groupProvider;
        this.identifier = identifier;
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalTeam that = (ExternalTeam)o;
        return Objects.equals(this.identifier, that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    @Generated
    public ExternalTeam() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getGroupProvider() {
        return this.groupProvider;
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getAdminName() {
        return this.adminName;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Set<Team> getTeams() {
        return this.teams;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setGroupProvider(String groupProvider) {
        this.groupProvider = groupProvider;
    }

    @Generated
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setAdminName(String adminName) {
        this.adminName = adminName;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @JsonIgnore
    @Generated
    public void setTeams(Set<Team> teams) {
        this.teams = teams;
    }
}

