/*
 * Decompiled with CFR 0.152.
 */
package teams.domain;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.util.StringUtils;
import teams.domain.ExternalTeam;
import teams.domain.Feature;
import teams.domain.Person;

public class FederatedUser
extends User {
    private final Map<String, String> config;
    private final String productName;
    private final Person person;
    private String groupNameContext;
    private List<ExternalTeam> externalTeams;
    private Map<Feature, Boolean> featureToggles;

    public FederatedUser(Person person, String productName, Map<String, String> config) {
        super(StringUtils.hasText((String)person.getName()) ? person.getName() : "No display name provided", "N/A", person.isGuest() ? Collections.singletonList(new SimpleGrantedAuthority("ROLE_USER")) : Arrays.asList(new SimpleGrantedAuthority("ROLE_USER"), new SimpleGrantedAuthority("ROLE_ADMIN")));
        this.person = person;
        this.config = config;
        this.productName = productName;
    }

    public FederatedUser(Person person, String groupNameContext, String productName, List<ExternalTeam> externalTeams, Map<Feature, Boolean> featureToggles, Map<String, String> config) {
        super(StringUtils.hasText((String)person.getName()) ? person.getName() : "No display name provided", "N/A", person.isGuest() ? Collections.singletonList(new SimpleGrantedAuthority("ROLE_USER")) : Arrays.asList(new SimpleGrantedAuthority("ROLE_USER"), new SimpleGrantedAuthority("ROLE_ADMIN")));
        this.person = person;
        this.groupNameContext = groupNameContext;
        this.productName = productName;
        this.externalTeams = externalTeams;
        this.featureToggles = featureToggles;
        this.config = config;
    }

    public String getUrn() {
        return this.person.getUrn();
    }

    public boolean featureEnabled(Feature feature) {
        return this.featureToggles.getOrDefault(feature, Boolean.FALSE);
    }

    @Generated
    public Map<String, String> getConfig() {
        return this.config;
    }

    @Generated
    public String getProductName() {
        return this.productName;
    }

    @Generated
    public Person getPerson() {
        return this.person;
    }

    @Generated
    public String getGroupNameContext() {
        return this.groupNameContext;
    }

    @Generated
    public List<ExternalTeam> getExternalTeams() {
        return this.externalTeams;
    }

    @Generated
    public Map<Feature, Boolean> getFeatureToggles() {
        return this.featureToggles;
    }
}

