/*
 * Decompiled with CFR 0.152.
 */
package teams.domain;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import teams.domain.AdminMember;
import teams.domain.FederatedUser;
import teams.domain.Invitation;
import teams.domain.InvitationMessage;
import teams.domain.Role;
import teams.domain.Team;

public class InvitationInfo {
    private String inviter;
    private Long expiryDate;
    private boolean accepted;
    private boolean expired;
    private boolean declined;
    private boolean alreadyMember;
    private InvitationMessage latestInvitationMessage;
    private Long teamId;
    private String teamName;
    private String teamDescription;
    private String invitationEmail;
    private Role intendedRole;
    private int daysValid;
    private List<AdminMember> admins;

    public InvitationInfo(Invitation invitation, FederatedUser federatedUser) {
        this.latestInvitationMessage = invitation.getLatestInvitationMessage();
        Team team = invitation.getTeam();
        this.teamId = team.getId();
        this.teamName = team.getName();
        this.teamDescription = team.getDescription();
        this.inviter = invitation.getLatestInvitationMessage().getPerson().getName();
        this.invitationEmail = invitation.getEmail();
        this.intendedRole = invitation.getIntendedRole();
        this.expiryDate = invitation.getExpiryDate() != null ? Long.valueOf(invitation.getExpiryDate().getEpochSecond()) : null;
        this.declined = invitation.isDeclined();
        this.accepted = invitation.isAccepted();
        this.expired = invitation.expired();
        this.alreadyMember = team.member(federatedUser.getUrn()).isPresent();
        this.daysValid = invitation.daysValid();
        this.admins = team.getMemberships().stream().filter(membership -> membership.getRole().equals((Object)Role.ADMIN) || membership.getRole().equals((Object)Role.OWNER)).map(membership -> new AdminMember(membership.getPerson())).collect(Collectors.toList());
    }

    @Generated
    public String getInviter() {
        return this.inviter;
    }

    @Generated
    public Long getExpiryDate() {
        return this.expiryDate;
    }

    @Generated
    public boolean isAccepted() {
        return this.accepted;
    }

    @Generated
    public boolean isExpired() {
        return this.expired;
    }

    @Generated
    public boolean isDeclined() {
        return this.declined;
    }

    @Generated
    public boolean isAlreadyMember() {
        return this.alreadyMember;
    }

    @Generated
    public InvitationMessage getLatestInvitationMessage() {
        return this.latestInvitationMessage;
    }

    @Generated
    public Long getTeamId() {
        return this.teamId;
    }

    @Generated
    public String getTeamName() {
        return this.teamName;
    }

    @Generated
    public String getTeamDescription() {
        return this.teamDescription;
    }

    @Generated
    public String getInvitationEmail() {
        return this.invitationEmail;
    }

    @Generated
    public Role getIntendedRole() {
        return this.intendedRole;
    }

    @Generated
    public int getDaysValid() {
        return this.daysValid;
    }

    @Generated
    public List<AdminMember> getAdmins() {
        return this.admins;
    }

    @Generated
    public void setInviter(String inviter) {
        this.inviter = inviter;
    }

    @Generated
    public void setExpiryDate(Long expiryDate) {
        this.expiryDate = expiryDate;
    }

    @Generated
    public void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }

    @Generated
    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    @Generated
    public void setDeclined(boolean declined) {
        this.declined = declined;
    }

    @Generated
    public void setAlreadyMember(boolean alreadyMember) {
        this.alreadyMember = alreadyMember;
    }

    @Generated
    public void setLatestInvitationMessage(InvitationMessage latestInvitationMessage) {
        this.latestInvitationMessage = latestInvitationMessage;
    }

    @Generated
    public void setTeamId(Long teamId) {
        this.teamId = teamId;
    }

    @Generated
    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    @Generated
    public void setTeamDescription(String teamDescription) {
        this.teamDescription = teamDescription;
    }

    @Generated
    public void setInvitationEmail(String invitationEmail) {
        this.invitationEmail = invitationEmail;
    }

    @Generated
    public void setIntendedRole(Role intendedRole) {
        this.intendedRole = intendedRole;
    }

    @Generated
    public void setDaysValid(int daysValid) {
        this.daysValid = daysValid;
    }

    @Generated
    public void setAdmins(List<AdminMember> admins) {
        this.admins = admins;
    }

    @Generated
    public InvitationInfo() {
    }
}

