/*
 * Decompiled with CFR 0.152.
 */
package teams.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import lombok.Generated;
import org.springframework.util.StringUtils;
import org.springframework.web.util.HtmlUtils;
import teams.domain.Invitation;
import teams.domain.Person;

@Entity(name="invitation_message")
public class InvitationMessage
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="invitation_id")
    @JsonIgnore
    private Invitation invitation;
    @Lob
    private String message;
    @Column(nullable=false)
    private long timestamp;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="person_id")
    @JsonIgnore
    private Person person;

    public InvitationMessage(Invitation invitation, Person person, String message) {
        this.invitation = invitation;
        this.person = person;
        this.message = StringUtils.hasText((String)message) ? message : null;
        this.timestamp = System.currentTimeMillis();
    }

    @JsonIgnore
    public boolean isContainsMessage() {
        return this.message != null;
    }

    @JsonIgnore
    public String getHtmlMessage() {
        return this.isContainsMessage() ? HtmlUtils.htmlEscape((String)this.message).replaceAll("\n", "<br/>") : "";
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Invitation getInvitation() {
        return this.invitation;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public Person getPerson() {
        return this.person;
    }

    @Generated
    public InvitationMessage() {
    }
}

